/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBWEB")
public interface CoyoteLogger
extends BasicLogger {
    public static final CoyoteLogger ROOT_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote");
    public static final CoyoteLogger UTIL_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.tomcat.util");
    public static final CoyoteLogger NET_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.tomcat.util.net");
    public static final CoyoteLogger HTTP_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote.http11");
    public static final CoyoteLogger HTTP_BIO_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote.http11.Http11Protocol");
    public static final CoyoteLogger HTTP_APR_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote.http11.Http11AprProtocol");
    public static final CoyoteLogger HTTP_NIO_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote.http11.Http11NioProtocol");
    public static final CoyoteLogger AJP_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.coyote.ajp");
    public static final CoyoteLogger BAYEUX_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.tomcat.bayeux");
    public static final CoyoteLogger MODELER_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.tomcat.util.modeler");
    public static final CoyoteLogger FILEUPLOAD_LOGGER = (CoyoteLogger)Logger.getMessageLogger(CoyoteLogger.class, (String)"org.apache.tomcat.util.http.fileupload");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3000, value="Coyote HTTP/1.1 starting on: %s")
    public void startHttpConnector(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3001, value="Coyote HTTP/1.1 initializing on : %s")
    public void initHttpConnector(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3002, value="Failed to load keystore type %s with path %s due to %s")
    public void errorLoadingKeystore(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3003, value="Failed to load keystore type %s with path %s due to %s")
    public void errorLoadingKeystoreWithException(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3004, value="Secure renegotiation is not supported by the SSL library %s")
    public void noInsecureRengotiation(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3005, value="Handshake failed: %s")
    public void handshakeFailed(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3006, value="Handshake failed")
    public void handshakeFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3007, value="Unexpected error processing socket")
    public void unexpectedError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3008, value="Maximum number of threads (%s) created for connector with address %s and port %s")
    public void maxThreadsReached(int var1, InetAddress var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3009, value="Failed to create poller with specified size of %s")
    public void limitedPollerSize(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3010, value="Poller creation failed")
    public void errorCreatingPoller(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3011, value="Error allocating socket processor")
    public void errorProcessingSocket(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3012, value="Socket accept failed")
    public void errorAcceptingSocket(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3013, value="Error processing timeouts")
    public void errorProcessingSocketTimeout(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3014, value="Unexpected poller error")
    public void errorPollingSocket();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3015, value="Unfiltered poll flag %s, sending error")
    public void errorPollingSocketCode(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3016, value="Critical poller failure (restarting poller): [%s] %s")
    public void pollerFailure(int var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3017, value="Unexpected poller error")
    public void errorPollingSocketWithException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3018, value="Unexpected sendfile error")
    public void errorSendingFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3019, value="Sendfile failure: [%s] %s")
    public void errorSendingFile(int var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3020, value="Error closing clannel")
    public void errorClosingChannel(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3021, value="Error closing socket")
    public void errorClosingSocket(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3022, value="Channel processing failed")
    public void errorProcessingChannel();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3023, value="Channel processing failed")
    public void errorProcessingChannelDebug(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3024, value="Channel processing failed")
    public void errorProcessingChannelWithException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3025, value="Error awaiting read")
    public void errorAwaitingRead(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3026, value="Error loading %s")
    public void errorLoading(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3027, value="Failed loading HTTP messages strings")
    public void errorLoadingMessages(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3028, value="Start processing with input [%s]")
    public void startProcessingParameter(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3029, value="Parameter starting at position [%s] and ending at position [%s] with a value of [%s] was not followed by an '=' character")
    public void parameterMissingEqual(int var1, int var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3030, value="Empty parameter chunk ignored")
    public void emptyParamterChunk();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3031, value="Invalid chunk starting at byte [%s] and ending at byte [%s] with a value of [%s] ignored")
    public void parameterInvalid(int var1, int var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3032, value="Failed to create copy of original parameter values for debug logging purposes")
    public void parametersCopyFailed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3033, value="Character decoding failed. Parameter [%s] with value [%s] has been ignored.")
    public void parameterDecodingFailed(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3034, value="Character decoding failed. A total of [%s] failures were detected. Enable debug level logging for this logger to log all failures.")
    public void parametersDecodingFailures(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3035, value="Parameters processing failed.")
    public void parametersProcessingFailed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3036, value="Invalid cookie header [%s].")
    public void invalidCookieHeader(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3037, value="Invalid special cookie [%s].")
    public void invalidSpecialCookie(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3038, value="Error processing request")
    public void errorProcessingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3039, value="Unexpected AJP message with type [%s].")
    public void unexpectedAjpMessage(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3040, value="Header message parsing failed.")
    public void errorParsingAjpHeaderMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3041, value="Error preparing AJP request.")
    public void errorPreparingAjpRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3042, value="Certificate conversion failed")
    public void errorProcessingCertificates(@Cause CertificateException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3043, value="Error initializing endpoint")
    public void errorInitializingEndpoint(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3044, value="Threadpool JMX registration failed")
    public void errorRegisteringPool(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3045, value="Error starting endpoint")
    public void errorStartingEndpoint(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3046, value="Starting Coyote AJP/1.3 on %s")
    public void startingAjpProtocol(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3047, value="Error pausing endpoint")
    public void errorPausingEndpoint(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3048, value="Pausing Coyote AJP/1.3 on %s")
    public void pausingAjpProtocol(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3049, value="Error resuming endpoint")
    public void errorResumingEndpoint(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3050, value="Resuming Coyote AJP/1.3 on %s")
    public void resumingAjpProtocol(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3051, value="Stopping Coyote AJP/1.3 on %s")
    public void stoppingAjpProtocol(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3052, value="Skip destroy for Coyote AJP/1.3 on %s due to active request processors")
    public void cannotDestroyAjpProtocol(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3053, value="Skip destroy for Coyote AJP/1.3 on %s due to active request processors")
    public void cannotDestroyAjpProtocolWithException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3054, value="Socket exception processing event.")
    public void socketException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3055, value="Error reading request, ignored.")
    public void socketError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3056, value="Error registering request")
    public void errorRegisteringRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3057, value="Error unregistering request")
    public void errorUnregisteringRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3058, value="Cannot append null value to AJP message")
    public void cannotAppendNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3059, value="Overflow error for buffer adding %s bytes at position %s")
    public void ajpMessageOverflow(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3060, value="Requested %s bytes exceeds message available data")
    public void ajpMessageUnderflow(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3061, value="Invalid message received with signature %s")
    public void invalidAjpMessage(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3062, value="Error parsing regular expression %s")
    public void errorParsingRegexp(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3063, value="Error during non blocking read")
    public void errorWithNonBlockingRead(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3064, value="Error during blocking read")
    public void errorWithBlockingRead(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3065, value="Error during non blocking write")
    public void errorWithNonBlockingWrite(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3066, value="Error during blocking write")
    public void errorWithBlockingWrite(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3067, value="Exception getting socket information")
    public void errorGettingSocketInformation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3068, value="Unknown filter %s")
    public void unknownFilter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3069, value="Error intializing filter %s")
    public void errorInitializingFilter(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3070, value="Error parsing HTTP request header")
    public void errorParsingHeader(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3071, value="Error preparing request")
    public void errorPreparingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3072, value="Error finishing request")
    public void errorFinishingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3073, value="Error finishing response")
    public void errorFinishingResponse(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3074, value="Exception getting SSL attributes")
    public void errorGettingSslAttributes(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3075, value="Coyote HTTP/1.1 pausing on: %s")
    public void pauseHttpConnector(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3076, value="Coyote HTTP/1.1 resuming on : %s")
    public void resumeHttpConnector(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3077, value="Coyote HTTP/1.1 stopping on : %s")
    public void stopHttpConnector(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3078, value="Skip destroy for Coyote HTTP/1.1 on %s due to active request processors")
    public void cannotDestroyHttpProtocol(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3079, value="Skip destroy for Coyote HTTP/1.1 on %s due to active request processors")
    public void cannotDestroyHttpProtocolWithException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3080, value="Error initializing socket factory")
    public void errorInitializingSocketFactory(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3081, value="Check Bayeux exception")
    public void errorInCheckBayeux(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3082, value="Error processing Bayeux")
    public void errorProcessingBayeux(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3083, value="Message delivery error")
    public void errorDeliveringBayeux(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3084, value="Failed setting property %s on object %s to %s")
    public void errorSettingProperty(String var1, Object var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3085, value="Failed getting property %s on object %s")
    public void errorGettingProperty(String var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3086, value="Bad maximum certificate length %s")
    public void invalidMaxCertLength(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3087, value="Error translating certificate %s")
    public void errorTranslatingCertificate(Certificate var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3088, value="SSL server initiated renegotiation is disabled, closing connection")
    public void disabledSslRenegociation();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3089, value="No descriptors found")
    public void noDescriptorsFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3090, value="No Mbeans found")
    public void noMbeansFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3091, value="Error reading descriptors")
    public void errorReadingDescriptors(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3092, value="Error creating MBean %s")
    public void errorCreatingMbean(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3093, value="Error invoking %s on %s")
    public void errorInvoking(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3094, value="Node not found %s")
    public void nodeNotFound(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3095, value="Error writing MBeans")
    public void errorWritingMbeans(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3096, value="Can't find attribute %s on %s")
    public void attributeNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3097, value="Error processing attribute %s value %s on %s")
    public void errorProcessingAttribute(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3098, value="Error sending notification")
    public void errorSendingNotification(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3099, value="Error creating object name")
    public void errorCreatingObjectName(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3100, value="Error invoking operation %s on %s")
    public void errorInvokingOperation(String var1, Object var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3101, value="No metadata for %s")
    public void noMetadata(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3102, value="Error unregistering MBean %s")
    public void errorUnregisteringMbean(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3103, value="Null %s component")
    public void nullComponent(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3104, value="Error registering MBean %s")
    public void errorRegisteringMbean(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3105, value="Socket accept failed")
    public void warnAcceptingSocket(@Cause Throwable var1);
}

