/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux.request;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CoyoteMessages;

public class MetaConnectRequest
extends RequestBase
implements BayeuxRequest {
    protected static HashMap<String, Object> responseTemplate = new HashMap();

    public MetaConnectRequest(TomcatBayeux tb, HttpEvent event, JSONObject jsReq) throws JSONException {
        super(tb, event, jsReq);
        if (this.clientId != null && this.getTomcatBayeux().hasClient(this.clientId)) {
            event.getHttpServletRequest().setAttribute("client", (Object)this.getTomcatBayeux().getClient(this.clientId));
        }
    }

    @Override
    public HttpError validate() {
        if (this.clientId == null || !this.getTomcatBayeux().hasClient(this.clientId)) {
            return new HttpError(400, CoyoteMessages.MESSAGES.invalidBayeuxClientId(), null);
        }
        if (!"long-polling".equals(this.conType) && !"callback-polling".equals(this.conType)) {
            return new HttpError(400, CoyoteMessages.MESSAGES.noBayeuxConnectionType(), null);
        }
        return null;
    }

    @Override
    public int process(int prevops) throws BayeuxException {
        int result;
        prevops = super.process(prevops);
        this.response = (HashMap)responseTemplate.clone();
        ClientImpl client = (ClientImpl)this.getTomcatBayeux().getClient(this.clientId);
        boolean success = false;
        HttpError error = this.validate();
        if (error == null) {
            client.setDesirectConnType(this.desiredConnTypeFlag);
            ((HashMap)this.response.get("advice")).put("reconnect", "retry");
            ((HashMap)this.response.get("advice")).put("interval", this.getReconnectInterval());
            success = true;
        } else {
            this.response.put("successful", Boolean.FALSE);
            this.response.put("error", error.toString());
            ((HashMap)this.response.get("advice")).put("reconnect", "handshake");
            if (client == null) {
                client = TomcatBayeux.getErrorClient();
            }
        }
        this.response.put("clientId", client.getId());
        this.response.put("timestamp", this.getTimeStamp());
        try {
            JSONObject obj = new JSONObject(this.response);
            this.addToDeliveryQueue(client, obj);
        }
        catch (ServletException x) {
            throw new BayeuxException(x);
        }
        catch (IOException x) {
            throw new BayeuxException(x);
        }
        int n = result = client.isSubscribed() ? 1 : 0;
        if (success && client != null && client.hasMessages()) {
            this.flushMessages(client);
            result = 0;
        }
        return result;
    }

    static {
        responseTemplate.put("channel", "/meta/connect");
        responseTemplate.put("successful", Boolean.TRUE);
        responseTemplate.put("advice", new HashMap());
    }
}

