/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.jdr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class JdrServerPluginComponent
implements ServerPluginComponent {
    private UUID accessToken;
    private static final Log log = LogFactory.getLog(JdrServerPluginComponent.class);
    private static final int LISTEN = 7079;
    private static final int SOCK_TIMEOUT = 5000;
    private static final String TOKEN_FILE_NAME = "jdr-token";
    private static final int TOKEN_SIZE = UUID.randomUUID().toString().length();
    private static final Object lock = new Object();
    private Thread serverThread;
    private ServerSocket server;

    public void initialize(ServerPluginContext context) throws Exception {
        this.setAccessToken();
        log.debug((Object)"Plugin initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccessToken() {
        Object object = lock;
        synchronized (object) {
            this.accessToken = UUID.randomUUID();
            this.writeAccessToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessToken() {
        Object object = lock;
        synchronized (object) {
            return this.accessToken.toString();
        }
    }

    private void writeAccessToken() {
        File dataDir = new File(System.getProperty("jboss.server.data.dir"));
        if (!dataDir.exists() || !dataDir.canWrite()) {
            log.error((Object)("Failed to write access token, jboss.server.data.dir=" + dataDir + " does not exist or not writable"));
            return;
        }
        File file = new File(dataDir, TOKEN_FILE_NAME);
        try {
            boolean isWindows;
            PrintWriter pw = new PrintWriter(file);
            pw.println(this.accessToken);
            pw.close();
            file.setWritable(true, true);
            file.setReadable(true, true);
            file.setExecutable(false, false);
            boolean bl = isWindows = File.separatorChar == '\\';
            if (!isWindows) {
                try {
                    Runtime.getRuntime().exec("chmod 600 " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error((Object)"Unable to set file permissions", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("Failed to write acces token, jboss.server.data.dir=" + file.getParent() + " does not exist or not writable"));
        }
    }

    public void start() {
        try {
            this.server = new ServerSocket(7079, 1, InetAddress.getByName(null));
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.debug((Object)"Listening on 7079");
                        while (true) {
                            Socket socket = JdrServerPluginComponent.this.server.accept();
                            socket.setSoTimeout(5000);
                            log.debug((Object)"Connection successfull");
                            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            String inputLine = null;
                            try {
                                char[] buffer = new char[TOKEN_SIZE];
                                int read = in.read(buffer);
                                if (read == TOKEN_SIZE) {
                                    inputLine = new String(buffer);
                                    if (inputLine.equals(JdrServerPluginComponent.this.getAccessToken())) {
                                        log.debug((Object)"Client authorized");
                                        out.println(JdrServerPluginComponent.this.getSystemInfo());
                                        log.debug((Object)"SystemInfo returned");
                                        JdrServerPluginComponent.this.setAccessToken();
                                    } else {
                                        log.debug((Object)"Invalid token recieved");
                                        out.println("Bye!");
                                    }
                                } else {
                                    log.debug((Object)"Invalid token recieved");
                                    out.println("Bye!");
                                }
                            }
                            catch (SocketTimeoutException ex) {
                                log.debug((Object)"Client timed out to send token");
                                out.println("Bye!");
                            }
                            in.close();
                            out.close();
                            socket.close();
                        }
                    }
                    catch (SocketException e) {
                    }
                    catch (Exception e) {
                        log.error((Object)"Socket server interrupted", (Throwable)e);
                    }
                }
            });
            this.serverThread.start();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    private String getSystemInfo() {
        try {
            SystemInfoManagerLocal mgr = LookupUtil.getSystemInfoManager();
            Map systemInfo = mgr.getSystemInformation(LookupUtil.getSubjectManager().getOverlord());
            ObjectWriter writer = new ObjectMapper().writerWithDefaultPrettyPrinter();
            return writer.writeValueAsString((Object)systemInfo);
        }
        catch (Exception e) {
            log.error((Object)e);
            return "ERROR retrieving system info : " + e.getMessage();
        }
    }

    public void stop() {
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        if (this.server != null) {
            try {
                if (!this.server.isClosed()) {
                    this.server.close();
                    log.debug((Object)"Socket server closed");
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void shutdown() {
        this.stop();
    }
}

