/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.Console;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.crypto.CryptoUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.installer.InstallerConfiguration;
import org.rhq.enterprise.server.installer.InstallerService;
import org.rhq.enterprise.server.installer.InstallerServiceImpl;

public class Installer {
    private static final Log LOG = LogFactory.getLog(Installer.class);
    private static final int EXIT_CODE_ALREADY_INSTALLED = 0;
    private static final int EXIT_CODE_INSTALLATION_DONE = 0;
    private static final int EXIT_CODE_AUTOINSTALL_DISABLED = 1;
    private static final int EXIT_CODE_INSTALLATION_ERROR = 2;
    private InstallerConfiguration installerConfig = new InstallerConfiguration();

    public static void main(String[] args) {
        try {
            Installer installer = new Installer();
            installer.doInstall(args);
        }
        catch (Exception e) {
            LOG.error((Object)"The installer will now exit due to previous errors", (Throwable)e);
            System.exit(2);
        }
        System.exit(0);
    }

    public InstallerConfiguration getInstallerConfiguration() {
        return this.installerConfig;
    }

    public void doInstall(String[] args) throws Exception {
        WhatToDo[] thingsToDo;
        block20: for (WhatToDo whatToDo : thingsToDo = this.processArguments(args)) {
            switch (whatToDo) {
                case DISPLAY_USAGE: {
                    this.displayUsage();
                    continue block20;
                }
                case LIST_SERVERS: {
                    new InstallerServiceImpl(this.installerConfig).listServers();
                    continue block20;
                }
                case LIST_VERSIONS: {
                    new InstallerServiceImpl(this.installerConfig).listVersions();
                    continue block20;
                }
                case TEST: {
                    try {
                        new InstallerServiceImpl(this.installerConfig).test();
                    }
                    catch (InstallerService.AutoInstallDisabledException e) {
                        LOG.error((Object)e.getMessage());
                        System.exit(1);
                    }
                    catch (InstallerService.AlreadyInstalledException e) {
                        LOG.info((Object)e.getMessage());
                        System.exit(0);
                    }
                    continue block20;
                }
                case SETUPDB: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.getServerProperties();
                        installerService.prepareDatabase(serverProperties, null, null, false);
                        LOG.info((Object)"Database setup is complete.");
                    }
                    catch (Exception e) {
                        LOG.error((Object)ThrowableUtil.getAllMessages((Throwable)e));
                        System.exit(2);
                    }
                    continue block20;
                }
                case UPDATESTORAGESCHEMA: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.getServerProperties();
                        installerService.updateStorageSchema(serverProperties);
                        LOG.info((Object)"Database setup is complete.");
                    }
                    catch (Exception e) {
                        LOG.error((Object)ThrowableUtil.getAllMessages((Throwable)e));
                        System.exit(2);
                    }
                    continue block20;
                }
                case INSTALL: 
                case UPGRADE: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.preInstall();
                        installerService.install(serverProperties, null, null, WhatToDo.UPGRADE == whatToDo);
                        LOG.info((Object)"Installation is complete. The server should be ready shortly.");
                    }
                    catch (InstallerService.AutoInstallDisabledException e) {
                        LOG.error((Object)e.getMessage());
                        System.exit(1);
                    }
                    catch (InstallerService.AlreadyInstalledException e) {
                        LOG.info((Object)e.getMessage());
                        System.exit(0);
                    }
                    continue block20;
                }
                case DO_NOTHING: {
                    continue block20;
                }
                default: {
                    throw new IllegalStateException("Please report this bug: " + (Object)((Object)whatToDo));
                }
            }
        }
    }

    private void displayUsage() {
        StringBuilder usage = new StringBuilder("RHQ Installer\n");
        usage.append("\t--help, -H: this help text").append("\n");
        usage.append("\t-Dname=value: set system properties for the Installer VM").append("\n");
        usage.append("\t--host=<hostname>, -h: hostname where the app server is running").append("\n");
        usage.append("\t--port=<port>, -p: talk to the app server over this management port").append("\n");
        usage.append("\t--test, -t: test the validity of the server properties (install not performed)").append("\n");
        usage.append("\t--force, -f: force the installer to try to install everything").append("\n");
        usage.append("\t--listservers, -l: show list of known installed servers (install not performed)").append("\n");
        usage.append("\t--listversions, -v: show list of server and storage node versions (install not performed)").append("\n");
        usage.append("\t--setupdb, -b: only perform database schema creation or update").append("\n");
        usage.append("\t--updatestorageschema, -u: only perform storage cluster schema update").append("\n");
        usage.append("\t--upgrade, -g: this is an upgrade installation (as opposed to a new install)").append("\n");
        usage.append("\t--encodevalue, -e: prompts for password or value to encode for editing configuration files for agent or server");
        usage.append("\n");
        LOG.info((Object)usage);
    }

    private WhatToDo[] processArguments(String[] args) throws Exception {
        int code;
        String sopts = "-:HD:h:p:e:buflt";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 72), new LongOpt("host", 1, null, 104), new LongOpt("port", 1, null, 112), new LongOpt("encodevalue", 0, null, 101), new LongOpt("setupdb", 0, null, 98), new LongOpt("updatestorageschema", 0, null, 117), new LongOpt("upgrade", 0, null, 103), new LongOpt("listservers", 0, null, 108), new LongOpt("listversions", 0, null, 118), new LongOpt("force", 0, null, 102), new LongOpt("test", 0, null, 116)};
        boolean test = false;
        boolean listservers = false;
        boolean listversions = false;
        boolean setupdb = false;
        boolean upgrade = false;
        boolean updatestorage = false;
        String valueToEncode = null;
        String associatedProperty = null;
        Getopt getopt = new Getopt("installer", args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    LOG.error((Object)"Invalid option");
                    return new WhatToDo[]{WhatToDo.DISPLAY_USAGE};
                }
                case 1: {
                    LOG.error((Object)("Unknown option: " + getopt.getOptarg()));
                    return new WhatToDo[]{WhatToDo.DISPLAY_USAGE};
                }
                case 72: {
                    return new WhatToDo[]{WhatToDo.DISPLAY_USAGE};
                }
                case 68: {
                    String value;
                    String name;
                    String sysprop = getopt.getOptarg();
                    int i = sysprop.indexOf("=");
                    if (i == -1) {
                        name = sysprop;
                        value = "true";
                    } else {
                        name = sysprop.substring(0, i);
                        value = sysprop.substring(i + 1, sysprop.length());
                    }
                    System.setProperty(name, value);
                    LOG.info((Object)("System property set: " + name + "=" + value));
                    break;
                }
                case 104: {
                    String hostString = getopt.getOptarg();
                    if (hostString == null) {
                        throw new IllegalArgumentException("Missing host value");
                    }
                    this.installerConfig.setManagementHost(hostString);
                    break;
                }
                case 112: {
                    String portString = getopt.getOptarg();
                    if (portString == null) {
                        throw new IllegalArgumentException("Missing port value");
                    }
                    this.installerConfig.setManagementPort(Integer.parseInt(portString));
                    break;
                }
                case 101: {
                    Console console = System.console();
                    if (null != console) {
                        associatedProperty = "rhq.autoinstall.server.admin.password";
                        if (!this.confirm(console, "Property " + associatedProperty)) {
                            associatedProperty = "rhq.server.database.password";
                            if (!this.confirm(console, "Property " + associatedProperty)) {
                                associatedProperty = this.ask(console, "Property: ");
                            }
                        }
                        String prompt = "Value: ";
                        if (associatedProperty != null && associatedProperty.toLowerCase().contains("password")) {
                            prompt = "Password: ";
                        }
                        valueToEncode = String.valueOf(console.readLine("%s", prompt));
                        break;
                    }
                    LOG.error((Object)"NO CONSOLE!");
                    break;
                }
                case 98: {
                    setupdb = true;
                    break;
                }
                case 103: {
                    upgrade = true;
                    break;
                }
                case 117: {
                    updatestorage = true;
                    break;
                }
                case 102: {
                    this.installerConfig.setForceInstall(true);
                    break;
                }
                case 108: {
                    listservers = true;
                    break;
                }
                case 116: {
                    test = true;
                    break;
                }
                case 118: {
                    listversions = true;
                }
            }
        }
        if (valueToEncode != null) {
            String encodedValue = "rhq.autoinstall.server.admin.password".equals(associatedProperty) ? CryptoUtil.createPasswordHash((String)"MD5", (String)"BASE64", null, null, valueToEncode) : new InstallerServiceImpl(this.installerConfig).obfuscatePassword(String.valueOf(valueToEncode));
            System.out.println("     ");
            System.out.println("     ");
            if ("rhq.server.database.password".equals(associatedProperty) || "rhq.autoinstall.server.admin.password".equals(associatedProperty) || "rhq.storage.password".equals(associatedProperty)) {
                System.out.println("Encoded password for rhq-server.properties:");
                System.out.println("     " + associatedProperty + "=" + encodedValue);
                System.out.println("     ");
            } else {
                String prompt = "value";
                if (associatedProperty != null && associatedProperty.toLowerCase().contains("password")) {
                    prompt = "password";
                }
                System.out.println("!!! WARNING !!!");
                System.out.println("Both standalone-full.xml and rhq-server.properties need to be updated if a property from rhq-server.properties is used in standalone-full.xml");
                System.out.println("!!! WARNING !!!");
                System.out.println("     ");
                System.out.println("Encoded " + prompt + " for rhq-server.properties:");
                System.out.println("     " + associatedProperty + "=RESTRICTED::" + encodedValue);
                System.out.println("     ");
                System.out.println("Encoded " + prompt + " for standalone-full.xml with selected " + prompt + " as default:");
                System.out.println("     ${VAULT::restricted::" + associatedProperty + "::" + encodedValue + "}");
                System.out.println("     ");
                System.out.println("Encoded " + prompt + " for standalone-full.xml without default:");
                System.out.println("     ${VAULT::restricted::" + associatedProperty + ":: }");
                System.out.println("     ");
                System.out.println("Encoded " + prompt + " for agent-configuration.xml:");
                System.out.println("     <entry key=\"" + associatedProperty + "\" value=\"RESTRICTED::" + encodedValue + "\" />");
                System.out.println("     ");
            }
            System.out.println("Please consult the documentation for additional help.");
            System.out.println("     ");
            return new WhatToDo[]{WhatToDo.DO_NOTHING};
        }
        if (test || setupdb || updatestorage || listservers || listversions) {
            ArrayList<WhatToDo> whatToDo = new ArrayList<WhatToDo>();
            if (test) {
                whatToDo.add(WhatToDo.TEST);
            }
            if (setupdb) {
                whatToDo.add(WhatToDo.SETUPDB);
            }
            if (updatestorage) {
                whatToDo.add(WhatToDo.UPDATESTORAGESCHEMA);
            }
            if (listservers) {
                whatToDo.add(WhatToDo.LIST_SERVERS);
            }
            if (listversions) {
                whatToDo.add(WhatToDo.LIST_VERSIONS);
            }
            return whatToDo.toArray(new WhatToDo[whatToDo.size()]);
        }
        return new WhatToDo[]{upgrade ? WhatToDo.UPGRADE : WhatToDo.INSTALL};
    }

    private String ask(Console console, String prompt) {
        String response = "";
        while ((response = String.valueOf(console.readLine("%s", prompt).trim())).isEmpty()) {
        }
        return response;
    }

    private boolean confirm(Console console, String option) {
        String response = "";
        while (!(response = this.ask(console, option + " [y/n]: ").trim().toLowerCase()).startsWith("y") && !response.startsWith("n")) {
        }
        return response.startsWith("y");
    }

    private static enum WhatToDo {
        DISPLAY_USAGE,
        DO_NOTHING,
        TEST,
        SETUPDB,
        LIST_SERVERS,
        INSTALL,
        UPDATESTORAGESCHEMA,
        LIST_VERSIONS,
        UPGRADE;

    }
}

