/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.rhq.cassandra.schema.DateRanges;
import org.rhq.cassandra.schema.Replace412Index;
import org.rhq.cassandra.schema.ReplaceRHQ411Index;
import org.rhq.cassandra.schema.Step;

public class ReplaceIndex
implements Step {
    private static final Log log = LogFactory.getLog(ReplaceIndex.class);
    private Session session;

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void bind(Properties properties) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void execute() {
        DateRanges dateRanges = new DateRanges();
        dateRanges.rawEndTime = DateTime.now().hourOfDay().roundFloorCopy();
        dateRanges.rawStartTime = dateRanges.rawEndTime.minusDays(3);
        dateRanges.oneHourStartTime = ReplaceIndex.getTimeSlice(dateRanges.rawStartTime, Hours.SIX.toStandardDuration());
        dateRanges.oneHourEndTime = ReplaceIndex.getTimeSlice(dateRanges.rawEndTime, Hours.SIX.toStandardDuration());
        dateRanges.sixHourStartTime = ReplaceIndex.getTimeSlice(dateRanges.rawStartTime, Days.ONE.toStandardDuration());
        dateRanges.sixHourEndTime = ReplaceIndex.getTimeSlice(dateRanges.rawEndTime, Days.ONE.toStandardDuration());
        if (this.cacheIndexExists()) {
            log.info((Object)"Preparing to replace metrics_cache_index");
            new Replace412Index(this.session).execute(dateRanges);
        } else {
            log.info((Object)"Preparing to replace metrics_index");
            new ReplaceRHQ411Index(this.session).execute(dateRanges);
        }
    }

    protected static DateTime getTimeSlice(DateTime dt, Duration duration) {
        Period p = duration.toPeriod();
        if (p.getYears() != 0) {
            return dt.yearOfEra().roundFloorCopy().minusYears(dt.getYearOfEra() % p.getYears());
        }
        if (p.getMonths() != 0) {
            return dt.monthOfYear().roundFloorCopy().minusMonths((dt.getMonthOfYear() - 1) % p.getMonths());
        }
        if (p.getWeeks() != 0) {
            return dt.weekOfWeekyear().roundFloorCopy().minusWeeks((dt.getWeekOfWeekyear() - 1) % p.getWeeks());
        }
        if (p.getDays() != 0) {
            return dt.dayOfMonth().roundFloorCopy().minusDays((dt.getDayOfMonth() - 1) % p.getDays());
        }
        if (p.getHours() != 0) {
            return dt.hourOfDay().roundFloorCopy().minusHours(dt.getHourOfDay() % p.getHours());
        }
        if (p.getMinutes() != 0) {
            return dt.minuteOfHour().roundFloorCopy().minusMinutes(dt.getMinuteOfHour() % p.getMinutes());
        }
        if (p.getSeconds() != 0) {
            return dt.secondOfMinute().roundFloorCopy().minusSeconds(dt.getSecondOfMinute() % p.getSeconds());
        }
        return dt.millisOfSecond().roundCeilingCopy().minusMillis(dt.getMillisOfSecond() % p.getMillis());
    }

    protected static DateTime getUTCTimeSlice(DateTime dateTime, Duration duration) {
        return ReplaceIndex.getTimeSlice(new DateTime(dateTime.getMillis(), DateTimeZone.UTC), duration);
    }

    protected static DateTime plusDSTAware(DateTime dateTime, Duration duration) {
        if (duration.toPeriod().getHours() <= 1) {
            dateTime = dateTime.plus((ReadableDuration)duration);
        } else {
            DateTimeZone zone = dateTime.getZone();
            int beforeOffset = zone.getOffset(dateTime.getMillis());
            dateTime = dateTime.plus((ReadableDuration)duration);
            int afterOffset = zone.getOffset(dateTime.getMillis());
            dateTime = dateTime.plus((long)(beforeOffset - afterOffset));
        }
        return dateTime;
    }

    private boolean cacheIndexExists() {
        ResultSet resultSet = this.session.execute("SELECT columnfamily_name FROM system.schema_columnfamilies WHERE keyspace_name = 'rhq' AND columnfamily_name = 'metrics_cache_index'");
        return !resultSet.isExhausted();
    }
}

