/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MigrationLog {
    private File logFile;
    private DataOutputStream outputStream;

    public MigrationLog(File logFile) throws IOException {
        this.logFile = logFile;
        this.outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(logFile, true), 2048));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> read() throws IOException {
        if (this.logFile.length() == 0L) {
            return Collections.emptySet();
        }
        HashSet<Integer> scheduleIds = new HashSet<Integer>();
        FilterInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(new FileInputStream(this.logFile));
            for (long bytesRead = 0L; bytesRead < this.logFile.length(); bytesRead += 4L) {
                scheduleIds.add(((DataInputStream)inputStream).readInt());
            }
            HashSet<Integer> hashSet = scheduleIds;
            return hashSet;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void write(int scheduleId) throws IOException {
        this.outputStream.writeInt(scheduleId);
    }

    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }
}

