/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.Session;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.cassandra.schema.Step;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class CQLStep
implements Step {
    private String parametrizeQuery;
    private String query;
    private Session session;

    public CQLStep(String query) {
        this.parametrizeQuery = query;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void bind(Properties properties) {
        HashSet<String> foundProperties = new HashSet<String>();
        Pattern regex = Pattern.compile("%([^%]*)%");
        Matcher matchPattern = regex.matcher(this.parametrizeQuery);
        while (matchPattern.find()) {
            String matchedString = matchPattern.group();
            String property = matchedString.substring(1, matchedString.length() - 1);
            foundProperties.add(property);
        }
        this.query = this.parametrizeQuery;
        if (foundProperties.size() != 0 && properties == null) {
            throw new RuntimeException("No properties provided but " + foundProperties.size() + " required for binding.");
        }
        if (foundProperties.size() != 0) {
            for (String foundProperty : foundProperties) {
                String propertyValue = properties.getProperty(foundProperty);
                if (propertyValue == null) {
                    throw new RuntimeException("Cannot bind query. Property [" + foundProperty + "] not found.");
                }
                this.query = this.query.replaceAll("%" + foundProperty + "%", propertyValue);
            }
            if (this.query.toUpperCase().contains("CREATE USER")) {
                this.query = this.replaceEncodedPassword(this.query);
            }
        }
    }

    private String replaceEncodedPassword(String step) {
        int firstQuoteIndex = step.indexOf("'");
        int lastQuoteIndex = step.lastIndexOf("'");
        String encodedPassword = step.substring(++firstQuoteIndex, lastQuoteIndex);
        String decodedPassword = PicketBoxObfuscator.decode((String)encodedPassword);
        String decodedStep = step.replace(encodedPassword, decodedPassword);
        return decodedStep;
    }

    @Override
    public void execute() {
        this.session.execute(this.query);
    }

    public String toString() {
        return this.parametrizeQuery;
    }
}

