/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.Bucket;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class AggregateNumericMetricMapper
implements ResultSetMapper<AggregateNumericMetric> {
    @Override
    public List<AggregateNumericMetric> mapAll(ResultSet resultSet) {
        ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
        for (Row row : resultSet) {
            metrics.add(this.map(row));
        }
        return metrics;
    }

    @Override
    public AggregateNumericMetric mapOne(ResultSet resultSet) {
        return this.map(resultSet.one());
    }

    @Override
    public List<AggregateNumericMetric> map(Row ... row) {
        ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
        for (int i = 0; i < row.length; i += 3) {
            AggregateNumericMetric metric = new AggregateNumericMetric();
            metric.setScheduleId(row[i].getInt(0));
            metric.setBucket(Bucket.fromString(row[i].getString(1)));
            metric.setTimestamp(row[i].getDate(2).getTime());
            metric.setAvg(row[i].getDouble(3));
            metric.setMax(row[i].getDouble(4));
            metric.setMin(row[i].getDouble(5));
            metrics.add(metric);
        }
        return metrics;
    }

    @Override
    public AggregateNumericMetric map(Row row) {
        return new AggregateNumericMetric(row.getInt(0), Bucket.fromString(row.getString(1)), row.getDouble(3), row.getDouble(5), row.getDouble(4), row.getDate(2).getTime());
    }
}

