/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.rhq.server.metrics.AbortedException;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageClientThreadFactory;
import org.rhq.server.metrics.aggregation.DataAggregator;
import org.rhq.server.metrics.aggregation.PersistFunctions;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.IndexBucket;

public class AggregationManager {
    private static final Comparator<AggregateNumericMetric> AGGREGATE_COMPARATOR = new Comparator<AggregateNumericMetric>(){

        @Override
        public int compare(AggregateNumericMetric left, AggregateNumericMetric right) {
            if (left.getScheduleId() == right.getScheduleId()) {
                if (left.getTimestamp() < right.getTimestamp()) {
                    return -1;
                }
                if (left.getTimestamp() > right.getTimestamp()) {
                    return 1;
                }
                return 0;
            }
            if (left.getScheduleId() < right.getScheduleId()) {
                return -1;
            }
            return 1;
        }
    };
    private final Log log = LogFactory.getLog(AggregationManager.class);
    private MetricsDAO dao;
    private DateTimeService dtService;
    private ListeningExecutorService aggregationTasks;
    private MetricsConfiguration configuration;
    private int batchSize;
    private int parallelism;
    private AtomicLong totalAggregationTime = new AtomicLong();
    private ThreadPoolExecutor threadPool;

    public AggregationManager(MetricsDAO dao, DateTimeService dtService, MetricsConfiguration configuration) {
        this.dao = dao;
        this.dtService = dtService;
        this.configuration = configuration;
        this.batchSize = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.batch-size", "5"));
        this.parallelism = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.parallelism", "3"));
        int numWorkers = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.workers", "4"));
        if (numWorkers < 2) {
            numWorkers = 2;
        }
        this.threadPool = new ThreadPoolExecutor(numWorkers, numWorkers, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new StorageClientThreadFactory("AggregationTasks"));
        this.aggregationTasks = MoreExecutors.listeningDecorator((ExecutorService)this.threadPool);
    }

    public void shutdown() {
        this.aggregationTasks.shutdownNow();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getNumWorkers() {
        return this.threadPool.getMaximumPoolSize();
    }

    public void setNumWorkers(int numWorkers) {
        this.log.debug((Object)("Setting aggregation worker thread count to " + numWorkers));
        this.threadPool.setCorePoolSize(numWorkers);
        this.threadPool.setMaximumPoolSize(numWorkers);
    }

    public long getTotalAggregationTime() {
        return this.totalAggregationTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AggregateNumericMetric> run() {
        this.log.info((Object)"Starting metrics data aggregation");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Semaphore permits = new Semaphore(this.batchSize * this.parallelism);
        this.log.debug((Object)("Allocating " + permits.availablePermits() + " permits"));
        int num1Hour = 0;
        int num6Hour = 0;
        int num24Hour = 0;
        try {
            DateTime endTime;
            PersistFunctions persistFunctions = new PersistFunctions(this.dao, this.dtService);
            final ConcurrentSkipListSet<AggregateNumericMetric> oneHourData = new ConcurrentSkipListSet<AggregateNumericMetric>(AGGREGATE_COMPARATOR);
            DateTime end = endTime = this.dtService.currentHour();
            DateTime start = end.minus((ReadablePeriod)this.configuration.getRawRetention().toPeriod().minusHours(1));
            DataAggregator rawAggregator = this.createRawAggregator(persistFunctions, permits);
            rawAggregator.setBatchFinishedListener(new DataAggregator.BatchFinishedListener(){

                @Override
                public void onFinish(List<AggregateNumericMetric> metrics) {
                    oneHourData.addAll(metrics);
                }
            });
            num1Hour = rawAggregator.execute(start, end);
            end = this.dtService.get6HourTimeSlice(endTime);
            start = this.dtService.get6HourTimeSlice(endTime).minus(this.configuration.getRawRetention());
            num6Hour = this.create1HourAggregator(persistFunctions, permits).execute(start, end);
            end = this.dtService.get24HourTimeSlice(endTime);
            start = this.dtService.get24HourTimeSlice(endTime).minus(this.configuration.getRawRetention());
            num24Hour = this.create6HourAggregator(persistFunctions, permits).execute(start, end);
            ConcurrentSkipListSet<AggregateNumericMetric> concurrentSkipListSet = oneHourData;
            return concurrentSkipListSet;
        }
        catch (InterruptedException e) {
            this.log.info((Object)"There was an interrupt while waiting for aggregation to finish. Aggregation will be aborted.");
            Set<AggregateNumericMetric> set = Collections.emptySet();
            return set;
        }
        catch (AbortedException e) {
            this.log.warn((Object)("Aggregation has been aborted: " + e.getMessage()));
            Set<AggregateNumericMetric> set = Collections.emptySet();
            return set;
        }
        finally {
            stopwatch.stop();
            this.totalAggregationTime.addAndGet(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.log.info((Object)("Finished aggregation of {\"raw schedules\": " + num1Hour + ", \"1 hour schedules\": " + num6Hour + ", \"6 hour schedules\": " + num24Hour + "} in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }
    }

    private DataAggregator createRawAggregator(PersistFunctions persistFunctions, Semaphore permits) {
        DataAggregator aggregator = new DataAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setBucket(IndexBucket.RAW);
        aggregator.setTimeSliceDuration(this.configuration.getRawTimeSliceDuration());
        aggregator.setDao(this.dao);
        aggregator.setPermits(permits);
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist1HourMetrics());
        aggregator.setConfiguration(this.configuration);
        aggregator.setBatchSize(this.batchSize);
        return aggregator;
    }

    private DataAggregator create1HourAggregator(PersistFunctions persistFunctions, Semaphore permits) {
        DataAggregator aggregator = new DataAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setBucket(IndexBucket.ONE_HOUR);
        aggregator.setTimeSliceDuration(this.configuration.getOneHourTimeSliceDuration());
        aggregator.setDao(this.dao);
        aggregator.setPermits(permits);
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist6HourMetrics());
        aggregator.setConfiguration(this.configuration);
        aggregator.setBatchSize(this.batchSize);
        return aggregator;
    }

    private DataAggregator create6HourAggregator(PersistFunctions persistFunctions, Semaphore permits) {
        DataAggregator aggregator = new DataAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setBucket(IndexBucket.SIX_HOUR);
        aggregator.setTimeSliceDuration(this.configuration.getSixHourTimeSliceDuration());
        aggregator.setDao(this.dao);
        aggregator.setPermits(permits);
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist24HourMetrics());
        aggregator.setConfiguration(this.configuration);
        aggregator.setBatchSize(this.batchSize);
        return aggregator;
    }
}

