/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;

public class MetricsConfiguration {
    private ReadablePeriod rawRetention = Days.days((int)7);
    private ReadablePeriod oneHourRetention = Days.days((int)14);
    private ReadablePeriod sixHourRetention = Days.days((int)31);
    private ReadablePeriod twentyFourHourRetention = Days.days((int)365);
    private int rawTTL = Duration.standardDays((long)7L).toStandardSeconds().getSeconds();
    private int oneHourTTL = Duration.standardDays((long)14L).toStandardSeconds().getSeconds();
    private int sixHourTTL = Duration.standardDays((long)31L).toStandardSeconds().getSeconds();
    private int twentyFourHourTTL = Duration.standardDays((long)365L).toStandardSeconds().getSeconds();
    private Duration rawTimeSliceDuration = Duration.standardHours((long)1L);
    private Duration oneHourTimeSliceDuration = Duration.standardHours((long)6L);
    private Duration sixHourTimeSliceDuration = Duration.standardHours((long)24L);
    private int indexPageSize = Integer.parseInt(System.getProperty("rhq.metrics.index.page-size", "2500"));
    private int indexPartitions = 10;

    public int getRawTTL() {
        return this.rawTTL;
    }

    public MetricsConfiguration setRawTTL(int rawTTL) {
        this.rawTTL = rawTTL;
        return this;
    }

    public int getOneHourTTL() {
        return this.oneHourTTL;
    }

    public MetricsConfiguration setOneHourTTL(int oneHourTTL) {
        this.oneHourTTL = oneHourTTL;
        return this;
    }

    public int getSixHourTTL() {
        return this.sixHourTTL;
    }

    public MetricsConfiguration setSixHourTTL(int sixHourTTL) {
        this.sixHourTTL = sixHourTTL;
        return this;
    }

    public int getTwentyFourHourTTL() {
        return this.twentyFourHourTTL;
    }

    public MetricsConfiguration setTwentyFourHourTTL(int twentyFourHourTTL) {
        this.twentyFourHourTTL = twentyFourHourTTL;
        return this;
    }

    public ReadablePeriod getRawRetention() {
        return this.rawRetention;
    }

    public MetricsConfiguration setRawRetention(Duration retention) {
        this.rawRetention = this.rawRetention;
        return this;
    }

    public ReadablePeriod getOneHourRetention() {
        return this.oneHourRetention;
    }

    public MetricsConfiguration setOneHourRetention(ReadablePeriod retention) {
        this.oneHourRetention = retention;
        return this;
    }

    public ReadablePeriod getSixHourRetention() {
        return this.sixHourRetention;
    }

    public MetricsConfiguration setSixHourRetention(ReadablePeriod retention) {
        this.sixHourRetention = retention;
        return this;
    }

    public ReadablePeriod getTwentyFourHourRetention() {
        return this.twentyFourHourRetention;
    }

    public MetricsConfiguration setTwentyFourHourRetention(ReadablePeriod retention) {
        this.twentyFourHourRetention = retention;
        return this;
    }

    public Duration getRawTimeSliceDuration() {
        return this.rawTimeSliceDuration;
    }

    public void setRawTimeSliceDuration(Duration rawTimeSliceDuration) {
        this.rawTimeSliceDuration = rawTimeSliceDuration;
    }

    public Duration getOneHourTimeSliceDuration() {
        return this.oneHourTimeSliceDuration;
    }

    public MetricsConfiguration setOneHourTimeSliceDuration(Duration oneHourTimeSliceDuration) {
        this.oneHourTimeSliceDuration = oneHourTimeSliceDuration;
        return this;
    }

    public Duration getSixHourTimeSliceDuration() {
        return this.sixHourTimeSliceDuration;
    }

    public MetricsConfiguration setSixHourTimeSliceDuration(Duration sixHourTimeSliceDuration) {
        this.sixHourTimeSliceDuration = sixHourTimeSliceDuration;
        return this;
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public MetricsConfiguration setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
        return this;
    }

    public int getIndexPartitions() {
        return this.indexPartitions;
    }

    public MetricsConfiguration setIndexPartitions(int indexPartitions) {
        this.indexPartitions = indexPartitions;
        return this;
    }
}

