/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.apache.james.mime4j.field.address.Builder;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.parser.AddressListParser;
import org.apache.james.mime4j.field.address.parser.ParseException;

public abstract class Address
implements Serializable {
    private static final long serialVersionUID = 634090661990433426L;

    final void addMailboxesTo(List<Mailbox> results) {
        this.doAddMailboxesTo(results);
    }

    protected abstract void doAddMailboxesTo(List<Mailbox> var1);

    public final String getDisplayString() {
        return this.getDisplayString(false);
    }

    public abstract String getDisplayString(boolean var1);

    public abstract String getEncodedString();

    public static Address parse(String rawAddressString) {
        AddressListParser parser = new AddressListParser(new StringReader(rawAddressString));
        try {
            return Builder.getInstance().buildAddress(parser.parseAddress());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.getDisplayString(false);
    }
}

