/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.codec.QuotedPrintableEncoder;

public class QuotedPrintableOutputStream
extends FilterOutputStream {
    private QuotedPrintableEncoder encoder;
    private boolean closed = false;

    public QuotedPrintableOutputStream(OutputStream out, boolean binary) {
        super(out);
        this.encoder = new QuotedPrintableEncoder(1024, binary);
        this.encoder.initEncoding(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.encoder.completeEncoding();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void flush() throws IOException {
        this.encoder.flushOutput();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("QuotedPrintableOutputStream has been closed");
        }
        this.encoder.encodeChunk(b, off, len);
    }
}

