/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;
    private long rowCount;

    public LinkedIndex(TableLink tableLink, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableLink, n, null, indexColumnArray, indexType);
        this.link = tableLink;
        this.targetTableName = this.link.getQualifiedTable();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    private static boolean isNull(Value value) {
        return value == null || value == ValueNull.INSTANCE;
    }

    @Override
    public void add(Session session, Row row) {
        ArrayList<Value> arrayList = New.arrayList();
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.targetTableName).append(" VALUES(");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value value = row.getValue(i);
            statementBuilder.appendExceptFirst(", ");
            if (value == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            if (LinkedIndex.isNull(value)) {
                statementBuilder.append("NULL");
                continue;
            }
            statementBuilder.append('?');
            arrayList.add(value);
        }
        statementBuilder.append(')');
        String string = statementBuilder.toString();
        try {
            this.link.execute(string, arrayList, true);
            ++this.rowCount;
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string, exception);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Object object;
        Object object2;
        int n;
        ArrayList<Value> arrayList = New.arrayList();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT * FROM ");
        statementBuilder.append(this.targetTableName).append(" T");
        for (n = 0; searchRow != null && n < searchRow.getColumnCount(); ++n) {
            object2 = searchRow.getValue(n);
            if (object2 == null) continue;
            statementBuilder.appendOnlyFirst(" WHERE ");
            statementBuilder.appendExceptFirst(" AND ");
            object = this.table.getColumn(n);
            statementBuilder.append(((Column)object).getSQL());
            if (object2 == ValueNull.INSTANCE) {
                statementBuilder.append(" IS NULL");
                continue;
            }
            statementBuilder.append(">=");
            this.addParameter(statementBuilder, (Column)object);
            arrayList.add((Value)object2);
        }
        for (n = 0; searchRow2 != null && n < searchRow2.getColumnCount(); ++n) {
            object2 = searchRow2.getValue(n);
            if (object2 == null) continue;
            statementBuilder.appendOnlyFirst(" WHERE ");
            statementBuilder.appendExceptFirst(" AND ");
            object = this.table.getColumn(n);
            statementBuilder.append(((Column)object).getSQL());
            if (object2 == ValueNull.INSTANCE) {
                statementBuilder.append(" IS NULL");
                continue;
            }
            statementBuilder.append("<=");
            this.addParameter(statementBuilder, (Column)object);
            arrayList.add((Value)object2);
        }
        String string = statementBuilder.toString();
        try {
            object2 = this.link.execute(string, arrayList, false);
            object = object2.getResultSet();
            return new LinkedCursor(this.link, (ResultSet)object, session, string, (PreparedStatement)object2);
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string, exception);
        }
    }

    private void addParameter(StatementBuilder statementBuilder, Column column) {
        if (column.getType() == 21 && this.link.isOracle()) {
            statementBuilder.append("CAST(? AS CHAR(").append(column.getPrecision()).append("))");
        } else {
            statementBuilder.append('?');
        }
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        return 100L + this.getCostRangeIndex(nArray, this.rowCount + 1000L);
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public void remove(Session session, Row row) {
        Object object;
        ArrayList<Value> arrayList = New.arrayList();
        StatementBuilder statementBuilder = new StatementBuilder("DELETE FROM ");
        statementBuilder.append(this.targetTableName).append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            statementBuilder.appendExceptFirst("AND ");
            object = this.table.getColumn(i);
            statementBuilder.append(((Column)object).getSQL());
            Value value = row.getValue(i);
            if (LinkedIndex.isNull(value)) {
                statementBuilder.append(" IS NULL ");
                continue;
            }
            statementBuilder.append('=');
            this.addParameter(statementBuilder, (Column)object);
            arrayList.add(value);
            statementBuilder.append(' ');
        }
        String string = statementBuilder.toString();
        try {
            object = this.link.execute(string, arrayList, false);
            int n = object.executeUpdate();
            this.link.reusePreparedStatement((PreparedStatement)object, string);
            this.rowCount -= (long)n;
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string, exception);
        }
    }

    public void update(Row row, Row row2) {
        Object object;
        int n;
        ArrayList<Value> arrayList = New.arrayList();
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.targetTableName).append(" SET ");
        for (n = 0; n < row2.getColumnCount(); ++n) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.table.getColumn(n).getSQL()).append('=');
            object = row2.getValue(n);
            if (object == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            statementBuilder.append('?');
            arrayList.add((Value)object);
        }
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (n = 0; n < row.getColumnCount(); ++n) {
            object = this.table.getColumn(n);
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(((Column)object).getSQL());
            Value value = row.getValue(n);
            if (LinkedIndex.isNull(value)) {
                statementBuilder.append(" IS NULL");
                continue;
            }
            statementBuilder.append('=');
            arrayList.add(value);
            this.addParameter(statementBuilder, (Column)object);
        }
        String string = statementBuilder.toString();
        try {
            this.link.execute(string, arrayList, true);
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string, exception);
        }
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

