/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.sso.infinispan;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.web.sso.FullyQualifiedSessionId;
import org.jboss.as.clustering.web.sso.SSOCredentials;
import org.jboss.as.clustering.web.sso.SSOLocalManager;
import org.jboss.as.clustering.web.sso.infinispan.CredentialKey;
import org.jboss.as.clustering.web.sso.infinispan.SSOKey;
import org.jboss.as.clustering.web.sso.infinispan.SessionKey;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

@Listener
public final class SSOClusterManager
implements org.jboss.as.clustering.web.sso.SSOClusterManager {
    private static final Logger log = Logger.getLogger(SSOClusterManager.class);
    private volatile Cache<SSOKey, Object> cache;
    private volatile Cache<CredentialKey, SSOCredentials> credentialCache;
    private volatile Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> sessionCache;
    private final InjectedValue<Cache> cacheRef = new InjectedValue();
    private volatile String cacheContainerName = "web";
    private volatile String cacheName = "sso";
    private final CacheInvoker invoker = new BatchCacheInvoker();
    private volatile SSOLocalManager ssoValve = null;

    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        builder.addDependency(CacheService.getServiceName((String)this.cacheContainerName, (String)this.cacheName), Cache.class, this.cacheRef);
    }

    public void setCacheContainerName(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void addSession(String ssoId, final FullyQualifiedSessionId sessionId) {
        if (log.isTraceEnabled()) {
            log.tracef("addSession(): adding Session %s to cached session set for SSO %s", (Object)sessionId.getSessionId(), (Object)ssoId);
        }
        final SessionKey key = new SessionKey(ssoId);
        SessionOperation<Void> operation = new SessionOperation<Void>(){

            public Void invoke(Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> cache) {
                ((Map)cache.putIfAbsent((Object)key, null)).put(sessionId, null);
                return null;
            }
        };
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation, new Flag[0]);
    }

    public SSOLocalManager getSSOLocalManager() {
        return this.ssoValve;
    }

    public void setSSOLocalManager(SSOLocalManager localManager) {
        this.ssoValve = localManager;
    }

    public void logout(final String ssoId) {
        if (log.isTraceEnabled()) {
            log.tracef("Registering logout of SSO %s in clustered cache", (Object)ssoId);
        }
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<SSOKey, Object> cache) {
                AdvancedCache removeCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP});
                removeCache.remove((Object)new SessionKey(ssoId));
                removeCache.remove((Object)new CredentialKey(ssoId));
                return null;
            }
        };
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
    }

    public SSOCredentials lookup(String ssoId) {
        return (SSOCredentials)this.credentialCache.get((Object)new CredentialKey(ssoId));
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (log.isTraceEnabled()) {
            log.tracef("Registering SSO %s in clustered cache", (Object)ssoId);
        }
        this.storeCredentials(ssoId, authType, username, password);
    }

    public void removeSession(String ssoId, FullyQualifiedSessionId sessionId) {
        SessionKey key;
        SessionOperation<Boolean> operation;
        if (log.isTraceEnabled()) {
            log.tracef("removeSession(): removing Session %s from cached session set for SSO %s", (Object)sessionId.getSessionId(), (Object)ssoId);
        }
        if (((Boolean)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)(operation = new SessionOperation<Boolean>(key = new SessionKey(ssoId), sessionId){
            final /* synthetic */ SessionKey val$key;
            final /* synthetic */ FullyQualifiedSessionId val$sessionId;
            {
                this.val$key = sessionKey;
                this.val$sessionId = fullyQualifiedSessionId;
            }

            public Boolean invoke(Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> cache) {
                Map sessions = (Map)cache.get((Object)this.val$key);
                if (sessions == null) {
                    return false;
                }
                sessions.remove(this.val$sessionId);
                return sessions.isEmpty();
            }
        }), new Flag[0])).booleanValue()) {
            this.notifySSOEmpty(ssoId);
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (log.isTraceEnabled()) {
            log.tracef("Updating credentials for SSO %s in clustered cache", (Object)ssoId);
        }
        this.storeCredentials(ssoId, authType, username, password);
    }

    @CacheEntryRemoved
    public void cacheEntryRemoved(CacheEntryRemovedEvent<SSOKey, ?> event) {
        if (log.isTraceEnabled()) {
            boolean isPre = event.isPre();
            boolean isOriginLocal = event.isOriginLocal();
            log.tracef("Received CacheEntryRemovedEvent from cluster: isPre = %s isOrigin = %s", (Object)Boolean.toString(isPre), (Object)Boolean.toString(isOriginLocal));
        }
        if (event.isPre()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (key instanceof SessionKey) {
            if (log.isTraceEnabled()) {
                log.tracef("cacheEntryRemoved ssoId = %s", (Object)ssoId);
            }
            if (!event.isOriginLocal()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"cacheEntryRemoved: event is not local- degeristering SSO key");
                }
                this.ssoValve.deregisterLocal(key.getId());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"CacheEntryRemoved: notifying SSO empty");
            }
            this.ssoValve.notifySSOEmpty(ssoId);
        }
    }

    private boolean notifySSOEmpty(String ssoId) {
        boolean empty;
        SessionKey key = new SessionKey(ssoId);
        boolean bl = empty = this.sessionCache.containsKey((Object)key) ? ((Map)this.sessionCache.get((Object)key)).isEmpty() : true;
        if (empty) {
            this.ssoValve.notifySSOEmpty(ssoId);
        }
        return empty;
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent<SSOKey, ?> event) {
        if (log.isTraceEnabled()) {
            boolean isPre = event.isPre();
            boolean isOriginLocal = event.isOriginLocal();
            log.tracef("Received CacheEntryModifiedEvent from cluster: isPre = %s isOrigin = %s", (Object)Boolean.toString(isPre), (Object)Boolean.toString(isOriginLocal));
        }
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (key instanceof CredentialKey) {
            SSOCredentials credentials;
            if (log.isTraceEnabled()) {
                log.tracef("received a credentials modified message for SSO %s", (Object)ssoId);
            }
            if ((credentials = (SSOCredentials)event.getValue()) != null) {
                this.ssoValve.remoteUpdate(ssoId, credentials);
            }
        } else if (key instanceof SessionKey) {
            if (log.isTraceEnabled()) {
                log.tracef("received a session modified message for SSO %s", (Object)ssoId);
            }
            if (!this.notifySSOEmpty(ssoId)) {
                this.ssoValve.notifySSONotEmpty(ssoId);
            }
        }
    }

    public void start() throws Exception {
        AdvancedCache cache;
        this.cache = cache = ((Cache)this.cacheRef.getValue()).getAdvancedCache();
        this.credentialCache = cache;
        this.sessionCache = new AtomicMapCache(cache);
        this.cache.addListener((Object)this);
    }

    public void stop() throws Exception {
        this.cache.removeListener((Object)this);
    }

    private void storeCredentials(final String ssoId, String authType, String username, String password) {
        final SSOCredentials credentials = new SSOCredentials(authType, username, password);
        CredentialOperation<Void> operation = new CredentialOperation<Void>(){

            public Void invoke(Cache<CredentialKey, SSOCredentials> cache) {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)new CredentialKey(ssoId), (Object)credentials);
                return null;
            }
        };
        this.invoker.invoke(this.credentialCache, (CacheInvoker.Operation)operation, new Flag[0]);
    }

    abstract class SessionOperation<R>
    implements CacheInvoker.Operation<SessionKey, Map<FullyQualifiedSessionId, Void>, R> {
        SessionOperation() {
        }
    }

    abstract class CredentialOperation<R>
    implements CacheInvoker.Operation<CredentialKey, SSOCredentials, R> {
        CredentialOperation() {
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<SSOKey, Object, R> {
        Operation() {
        }
    }
}

