/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.msc.value.Value;

public class WebSessionCacheConfigurationService
extends AbstractCacheConfigurationService {
    private final Value<Configuration> configuration;
    private final Value<EmbeddedCacheManager> container;
    private final boolean passivationEnabled;

    public WebSessionCacheConfigurationService(String name, Value<EmbeddedCacheManager> container, Value<Configuration> configuration, JBossWebMetaData metaData) {
        super(name);
        this.configuration = configuration;
        this.container = container;
        this.passivationEnabled = WebSessionCacheConfigurationService.isPassivationEnabled(metaData);
    }

    private static boolean isPassivationEnabled(JBossWebMetaData metaData) {
        Boolean usePassivation;
        PassivationConfig config = metaData.getPassivationConfig();
        if (config != null && (usePassivation = config.getUseSessionPassivation()) != null) {
            return usePassivation;
        }
        return false;
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder().read((Configuration)this.configuration.getValue());
        if (this.passivationEnabled) {
            builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        return builder;
    }

    protected EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.container.getValue();
    }
}

