/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.DeploymentException;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.TokenReplacingProperties;
import org.rhq.core.util.TokenReplacingReader;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.stream.StreamUtil;

public class Deployer {
    private final Log log = LogFactory.getLog(Deployer.class);
    private DeploymentOptions deploymentOptions;

    public void setDeploymentOptions(DeploymentOptions deploymentOptions) {
        this.deploymentOptions = deploymentOptions;
    }

    public void unzipDistro() throws DeploymentException {
        InputStream inputStream = this.getClass().getResourceAsStream("/cassandra.zip");
        File deployDir = new File(this.deploymentOptions.getBasedir());
        deployDir.mkdir();
        try {
            this.log.info((Object)("Unzipping storage node to " + deployDir));
            ZipUtil.unzipFile((InputStream)inputStream, (File)deployDir);
        }
        catch (IOException e) {
            this.log.error((Object)"An error occurred while unzipping the storage zip file", (Throwable)e);
            throw new DeploymentException("An error occurred while unzipping the storage zip file", e);
        }
    }

    public void applyConfigChanges() throws DeploymentException {
        File deployDir = new File(this.deploymentOptions.getBasedir());
        File confDir = new File(deployDir, "conf");
        TokenReplacingProperties tokens = this.deploymentOptions.toMap();
        tokens.put("cluster.name", "rhq");
        this.applyConfigChanges(confDir, "cassandra.yaml", (Map<String, String>)tokens);
        this.applyConfigChanges(confDir, "log4j-server.properties", (Map<String, String>)tokens);
        this.applyChangesToCassandraJvmProps(confDir, this.deploymentOptions);
        if (File.separatorChar == '\\') {
            this.applyChangesToWindowsServiceWrapper(deployDir);
        }
    }

    private void applyConfigChanges(File confDir, String fileName, Map<String, String> tokens) throws DeploymentException {
        File filteredFile = new File(confDir, fileName);
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Applying configuration changes to " + filteredFile));
            }
            File rhqFile = new File(confDir, "rhq." + fileName);
            TokenReplacingReader reader = new TokenReplacingReader((Reader)new FileReader(rhqFile), tokens);
            StreamUtil.copy((Reader)reader, (Writer)new FileWriter(filteredFile));
            rhqFile.delete();
        }
        catch (IOException e) {
            this.log.error((Object)("An unexpected error occurred while apply configuration changes to " + filteredFile), (Throwable)e);
            throw new DeploymentException("An unexpected error occurred while apply configuration changes to " + filteredFile, e);
        }
    }

    private void applyChangesToCassandraJvmProps(File confDir, DeploymentOptions deploymentOptions) throws DeploymentException {
        File jvmPropsFile = new File(confDir, "cassandra-jvm.properties");
        try {
            this.log.info((Object)("Applying configuration changes to " + jvmPropsFile));
            PropertiesFileUpdate propertiesUpdater = new PropertiesFileUpdate(jvmPropsFile.getAbsolutePath());
            Properties properties = propertiesUpdater.loadExistingProperties();
            properties.setProperty("heap_min", "-Xms" + deploymentOptions.getHeapSize());
            properties.setProperty("heap_max", "-Xmx" + deploymentOptions.getHeapSize());
            properties.setProperty("heap_new", "-Xmn" + deploymentOptions.getHeapNewSize());
            properties.setProperty("thread_stack_size", "-Xss" + deploymentOptions.getStackSize());
            properties.setProperty("jmx_port", deploymentOptions.getJmxPort().toString());
            String javaVersion = System.getProperty("java.version");
            if (!this.isOpenJDK() || javaVersion.compareTo("1.6.0") > 0 || javaVersion.equals("1.6.0") && this.getJavaPatchVersion() > 23) {
                properties.put("java_agent", "-javaagent:$CASSANDRA_HOME/lib/jamm-0.2.5.jar");
            }
            propertiesUpdater.update(properties);
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while updating " + jvmPropsFile), (Throwable)e);
            throw new DeploymentException("An error occurred while updating " + jvmPropsFile, e);
        }
    }

    private boolean isOpenJDK() {
        String javaVMName = System.getProperty("java.vm.name");
        return javaVMName.startsWith("OpenJDK");
    }

    private boolean isJava1_6() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.startsWith("1.6.0");
    }

    private int getJavaPatchVersion() {
        String javaVersion = System.getProperty("java.version");
        int startIndex = javaVersion.indexOf(95);
        if (startIndex == -1) {
            return 0;
        }
        return Integer.parseInt(javaVersion.substring(startIndex + 1, javaVersion.length()));
    }

    public void applyChangesToWindowsServiceWrapper(File deployDir) throws DeploymentException {
        File wrapperDir = new File(deployDir, "../bin/wrapper");
        File wrapperEnvFile = new File(wrapperDir, "rhq-storage-wrapper.env");
        try {
            this.log.info((Object)("Applying configuration changes to " + wrapperEnvFile));
            PropertiesFileUpdate propertiesUpdater = new PropertiesFileUpdate(wrapperEnvFile.getAbsolutePath());
            Properties wrapperEnvProps = propertiesUpdater.loadExistingProperties();
            wrapperEnvProps.setProperty("set.heap_min", "-Xms" + this.deploymentOptions.getHeapSize());
            wrapperEnvProps.setProperty("set.heap_max", "-Xmx" + this.deploymentOptions.getHeapSize());
            wrapperEnvProps.setProperty("set.heap_new", "-Xmn" + this.deploymentOptions.getHeapNewSize());
            wrapperEnvProps.setProperty("set.thread_stack_size", "-Xss" + this.deploymentOptions.getStackSize());
            wrapperEnvProps.setProperty("set.jmx_port", this.deploymentOptions.getJmxPort().toString());
            wrapperEnvProps.setProperty("set.heap_dump_on_OOMError", "-XX:+HeapDumpOnOutOfMemoryError");
            wrapperEnvProps.setProperty("set.heap_dump_dir", "-XX:HeapDumpPath=" + Deployer.useForwardSlash(new File(deployDir, "bin").getAbsolutePath()));
            propertiesUpdater.update(wrapperEnvProps);
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while updating " + wrapperEnvFile), (Throwable)e);
            throw new DeploymentException("An error occurred while updating " + wrapperEnvFile, e);
        }
    }

    private static String useForwardSlash(String path) {
        return null != path ? path.replace('\\', '/') : null;
    }

    public void updateFilePerms() {
        File deployDir = new File(this.deploymentOptions.getBasedir());
        File binDir = new File(deployDir, "bin");
        this.log.info((Object)("Updating file permissions in " + binDir));
        for (File f : binDir.listFiles()) {
            f.setExecutable(true);
        }
    }

    public void updateStorageAuthConf(Set<String> addresses) {
        File confDir = new File(this.deploymentOptions.getBasedir(), "conf");
        File authFile = new File(confDir, "rhq-storage-auth.conf");
        try {
            authFile.delete();
            StreamUtil.copy((Reader)new StringReader(StringUtil.collectionToString(addresses, (String)"\n")), (Writer)new FileWriter(authFile), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update " + authFile);
        }
    }
}

