/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.txn.TransactionLogger;
import org.jboss.as.txn.TransactionMessages;
import org.jboss.as.txn.subsystem.CMResourceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class CMResourceAdd
extends AbstractAddStepHandler {
    static CMResourceAdd INSTANCE = new CMResourceAdd();

    CMResourceAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String str = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        if (!str.startsWith("java:/") && !str.startsWith("java:jboss/")) {
            throw TransactionMessages.MESSAGES.jndiNameInvalidFormat();
        }
        CMResourceResourceDefinition.CM_TABLE_NAME.validateAndSet(operation, model);
        CMResourceResourceDefinition.CM_TABLE_BATCH_SIZE.validateAndSet(operation, model);
        CMResourceResourceDefinition.CM_TABLE_IMMEDIATE_CLEANUP.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String jndiName = address.getLastElement().getValue();
        String tableName = CMResourceResourceDefinition.CM_TABLE_NAME.resolveModelAttribute(context, model).asString();
        int batchSize = CMResourceResourceDefinition.CM_TABLE_BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        boolean immediateCleanup = CMResourceResourceDefinition.CM_TABLE_IMMEDIATE_CLEANUP.resolveModelAttribute(context, model).asBoolean();
        TransactionLogger.ROOT_LOGGER.debugf("adding commit-markable-resource: jndi-name=%s, table-name=%s, batch-size=%d, immediate-cleanup=%b", new Object[]{jndiName, tableName, batchSize, immediateCleanup});
        JTAEnvironmentBean jTAEnvironmentBean = (JTAEnvironmentBean)BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class);
        List connectableResourceJNDINames = jTAEnvironmentBean.getCommitMarkableResourceJNDINames();
        Map connectableResourceTableNameMap = jTAEnvironmentBean.getCommitMarkableResourceTableNameMap();
        Map performImmediateCleanupOfConnectableResourceBranchesMap = jTAEnvironmentBean.getPerformImmediateCleanupOfCommitMarkableResourceBranchesMap();
        Map connectableResourceRecordDeleteBatchSizeMap = jTAEnvironmentBean.getCommitMarkableResourceRecordDeleteBatchSizeMap();
        connectableResourceJNDINames.add(jndiName);
        connectableResourceTableNameMap.put(jndiName, tableName);
        performImmediateCleanupOfConnectableResourceBranchesMap.put(jndiName, immediateCleanup);
        connectableResourceRecordDeleteBatchSizeMap.put(jndiName, batchSize);
        jTAEnvironmentBean.setCommitMarkableResourceJNDINames(connectableResourceJNDINames);
        jTAEnvironmentBean.setCommitMarkableResourceTableNameMap(connectableResourceTableNameMap);
        jTAEnvironmentBean.setPerformImmediateCleanupOfCommitMarkableResourceBranchesMap(performImmediateCleanupOfConnectableResourceBranchesMap);
        jTAEnvironmentBean.setCommitMarkableResourceRecordDeleteBatchSizeMap(connectableResourceRecordDeleteBatchSizeMap);
    }
}

