/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

public class ResourceComponentUtils {
    private static final String CUSTOM_PROPERTIES_PROPERTY = "customProperties";
    private static final Log LOG = LogFactory.getLog(ResourceComponentUtils.class);

    public static Map<String, PropertySimple> getCustomProperties(Configuration pluginConfig) {
        LinkedHashMap<String, PropertySimple> customProperties = new LinkedHashMap<String, PropertySimple>();
        if (pluginConfig == null) {
            return customProperties;
        }
        PropertyMap customPropsMap = pluginConfig.getMap(CUSTOM_PROPERTIES_PROPERTY);
        if (customPropsMap != null) {
            Collection customProps = customPropsMap.getMap().values();
            for (Property customProp : customProps) {
                if (!(customProp instanceof PropertySimple)) {
                    LOG.error((Object)("Custom property definitions in plugin configuration must be simple properties - property " + customProp + " is not - ignoring..."));
                    continue;
                }
                customProperties.put(customProp.getName(), (PropertySimple)customProp);
            }
        }
        return customProperties;
    }

    public static String replacePropertyExpressionsInTemplate(String template, Configuration configuration) {
        if (template == null) {
            return null;
        }
        Pattern propExpressionPattern = Pattern.compile("%[^%]+%");
        Matcher matcher = propExpressionPattern.matcher(template);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group();
            String propName = match.substring(1, match.length() - 1);
            PropertySimple prop = configuration.getSimple(propName);
            if (prop == null) {
                LOG.debug((Object)("WARNING: Template '" + template + "' references property '" + propName + "' that does not exist in " + configuration.toString(true)));
                continue;
            }
            if (prop.getStringValue() == null) continue;
            matcher.appendReplacement(stringBuffer, prop.getStringValue());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

