/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.profileservice.spi.ProfileKey;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.content.FileContentDelegate;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.JarContentFileInfo;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

public class StandaloneManagedDeploymentComponent
extends AbstractManagedDeploymentComponent
implements MeasurementFacet,
ContentFacet,
DeleteResourceFacet {
    private static final Log LOG = LogFactory.getLog(StandaloneManagedDeploymentComponent.class);
    private static final String CUSTOM_PATH_TRAIT = "custom.path";
    private static final String CUSTOM_EXPLODED_TRAIT = "custom.exploded";
    @Deprecated
    public static final String RHQ_SHA256 = "RHQ-Sha256";
    private static final String PKG_TYPE_FILE = "file";
    private static final String ARCHITECTURE = "noarch";
    private static final ProfileKey FARM_PROFILE_KEY = new ProfileKey("farm");
    private static final ProfileKey APPLICATIONS_PROFILE_KEY = new ProfileKey("applications");

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> remainingRequests = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            if (metricName.equals(CUSTOM_PATH_TRAIT)) {
                MeasurementDataTrait trait = new MeasurementDataTrait(request, this.deploymentFile.getPath());
                report.addData(trait);
                continue;
            }
            if (metricName.equals(CUSTOM_EXPLODED_TRAIT)) {
                boolean exploded = this.deploymentFile.isDirectory();
                MeasurementDataTrait trait = new MeasurementDataTrait(request, exploded ? "yes" : "no");
                report.addData(trait);
                continue;
            }
            remainingRequests.add(request);
        }
        super.getValues(report, remainingRequests);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        File packageFile = new File(packageDetails.getName());
        try {
            File fileToSend;
            if (!packageFile.exists() && this.deploymentFile != null) {
                packageFile = this.deploymentFile;
            }
            if (packageFile.isDirectory()) {
                fileToSend = File.createTempFile("rhq", ".zip");
                ZipUtil.zipFileOrDirectory((File)packageFile, (File)fileToSend);
            } else {
                fileToSend = packageFile;
            }
            return new BufferedInputStream(new FileInputStream(fileToSend));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve package bits for " + packageDetails, e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType packageType) {
        if (!this.deploymentFile.exists()) {
            throw new IllegalStateException("Deployment file '" + this.deploymentFile + "' for " + this.getResourceDescription() + " does not exist.");
        }
        String fileName = this.deploymentFile.getName();
        String sha256 = this.getSHA256(this.deploymentFile);
        String version = this.getVersion(sha256);
        String displayVersion = this.getDisplayVersion(this.deploymentFile);
        PackageDetailsKey key = new PackageDetailsKey(fileName, version, PKG_TYPE_FILE, ARCHITECTURE);
        ResourcePackageDetails packageDetails = new ResourcePackageDetails(key);
        packageDetails.setFileName(fileName);
        packageDetails.setLocation(this.deploymentFile.getPath());
        if (!this.deploymentFile.isDirectory()) {
            packageDetails.setFileSize(Long.valueOf(this.deploymentFile.length()));
        }
        packageDetails.setFileCreatedDate(null);
        packageDetails.setSHA256(sha256);
        packageDetails.setInstallationTimestamp(Long.valueOf(System.currentTimeMillis()).longValue());
        packageDetails.setDisplayVersion(displayVersion);
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        packages.add(packageDetails);
        return packages;
    }

    private String getSHA256(File file) {
        String sha256;
        block2: {
            sha256 = null;
            try {
                FileContentDelegate fileContentDelegate = new FileContentDelegate();
                sha256 = fileContentDelegate.retrieveDeploymentSHA(file, this.getResourceContext().getResourceDataDirectory());
            }
            catch (Exception iex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("Problem calculating digest of package [" + file.getPath() + "]." + iex.getMessage()));
            }
        }
        return sha256;
    }

    private String getVersion(String sha256) {
        return "[sha256=" + sha256 + "]";
    }

    private String getDisplayVersion(File file) {
        JarContentFileInfo contentFileInfo = new JarContentFileInfo(file);
        return contentFileInfo.getVersion(null);
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException("Cannot remove the package backing an EAR/WAR resource.");
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        DeploymentProgress progress;
        String deploymentName;
        File tempFile;
        String resourceTypeName = this.getResourceContext().getResourceType().getName();
        if (packages.size() != 1) {
            LOG.warn((Object)("Request to update " + resourceTypeName + " file contained multiple packages: " + packages));
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Only one " + resourceTypeName + " can be updated at a time.");
            return response;
        }
        ResourcePackageDetails packageDetails = packages.iterator().next();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating EAR/WAR file '" + this.deploymentFile + "' using [" + packageDetails + "]..."));
        }
        if (!this.deploymentFile.exists()) {
            return this.failApplicationDeployment("Could not find application to update at location: " + this.deploymentFile, packageDetails);
        }
        LOG.debug((Object)"Writing new EAR/WAR bits to temporary file...");
        try {
            tempFile = this.writeNewAppBitsToTempFile(contentServices, packageDetails);
        }
        catch (Exception e) {
            return this.failApplicationDeployment("Error writing new application bits to temporary file - cause: " + e, packageDetails);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Wrote new EAR/WAR bits to temporary file '" + tempFile + "'."));
        }
        boolean deployExploded = this.deploymentFile.isDirectory();
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File backupDir = new File(tempDir, "deployBackup" + UUID.randomUUID().getLeastSignificantBits());
        File backupOfOriginalFile = new File(backupDir, this.deploymentFile.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Backing up existing EAR/WAR '" + this.deploymentFile + "' to '" + backupOfOriginalFile + "'..."));
        }
        try {
            if (backupOfOriginalFile.exists()) {
                FileUtils.forceDelete((File)backupOfOriginalFile);
            }
            if (this.deploymentFile.isDirectory()) {
                FileUtils.copyDirectory((File)this.deploymentFile, (File)backupOfOriginalFile, (boolean)true);
            } else {
                FileUtils.copyFile((File)this.deploymentFile, (File)backupOfOriginalFile, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to backup existing " + resourceTypeName + "'" + this.deploymentFile + "' to '" + backupOfOriginalFile + "'.");
        }
        ProfileServiceConnection connection = this.getConnection();
        if (connection == null) {
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("No profile service connection available");
            return response;
        }
        DeploymentManager deploymentManager = connection.getDeploymentManager();
        boolean deployFarmed = this.getDeploymentKey().contains("/farm/");
        if (deployFarmed) {
            Collection profileKeys = deploymentManager.getProfiles();
            boolean farmSupported = false;
            for (ProfileKey profileKey : profileKeys) {
                if (!profileKey.getName().equals(FARM_PROFILE_KEY.getName())) continue;
                farmSupported = true;
                break;
            }
            if (!farmSupported) {
                throw new IllegalStateException("This application server instance is not a node in a cluster, so it does not support farmed deployments. Supported deployment profiles are " + profileKeys + ".");
            }
            if (deployExploded) {
                throw new IllegalArgumentException("Deploying farmed applications in exploded form is not supported by the Profile Service.");
            }
            try {
                deploymentManager.loadProfile(FARM_PROFILE_KEY);
            }
            catch (Exception e) {
                LOG.info((Object)("Failed to switch to farm profile - could not update " + resourceTypeName + " file '" + this.deploymentFile + "' using [" + packageDetails + "]."));
                String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
                return this.failApplicationDeployment(errorMessage, packageDetails);
            }
        }
        if ((deploymentName = this.getDeploymentName()) == null) {
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Did not find deployment with key [" + this.getDeploymentKey() + "]");
            return response;
        }
        try {
            progress = deploymentManager.stop(new String[]{deploymentName});
            DeploymentUtils.run(progress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop deployment [" + deploymentName + "].", e);
        }
        try {
            progress = deploymentManager.remove(new String[]{deploymentName});
            DeploymentUtils.run(progress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remove deployment [" + deploymentName + "].", e);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deploying '" + tempFile + "'..."));
            }
            DeploymentUtils.deployArchive(deploymentManager, tempFile, deployExploded);
        }
        catch (Exception e) {
            LOG.debug((Object)"Redeploy failed - rolling back to original archive...", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            try {
                block45: {
                    if (this.deploymentFile.exists()) {
                        try {
                            FileUtils.forceDelete((File)this.deploymentFile);
                        }
                        catch (IOException e1) {
                            if (!LOG.isDebugEnabled()) break block45;
                            LOG.debug((Object)("Failed to delete application file '" + this.deploymentFile + "' that failed to deploy."), (Throwable)e1);
                        }
                    }
                }
                DeploymentUtils.deployArchive(deploymentManager, backupOfOriginalFile, deployExploded);
                errorMessage = errorMessage + " ***** ROLLED BACK TO ORIGINAL APPLICATION FILE. *****";
                this.deleteTemporaryFile(backupDir);
            }
            catch (Exception e1) {
                LOG.debug((Object)"Rollback failed!", (Throwable)e1);
                errorMessage = errorMessage + " ***** FAILED TO ROLLBACK TO ORIGINAL APPLICATION FILE. *****: " + ThrowableUtil.getAllMessages((Throwable)e1);
            }
            this.deleteTemporaryFile(tempFile);
            LOG.info((Object)("Failed to update " + resourceTypeName + " file '" + this.deploymentFile + "' using [" + packageDetails + "]."));
            DeployPackagesResponse deployPackagesResponse = this.failApplicationDeployment(errorMessage, packageDetails);
            return deployPackagesResponse;
        }
        finally {
            if (deployFarmed) {
                try {
                    deploymentManager.loadProfile(APPLICATIONS_PROFILE_KEY);
                }
                catch (Exception e) {
                    LOG.debug((Object)"Failed to switch back to applications profile from farm profile", (Throwable)e);
                }
            }
        }
        if (this.deploymentFile.isDirectory()) {
            FileContentDelegate fileContentDelegate = new FileContentDelegate();
            fileContentDelegate.saveDeploymentSHA(tempFile, this.deploymentFile, this.getResourceContext().getResourceDataDirectory());
        }
        this.deleteTemporaryFile(backupDir);
        this.deleteTemporaryFile(tempFile.getParentFile());
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.SUCCESS);
        response.addPackageResponse(packageResponse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updated " + resourceTypeName + " file '" + this.deploymentFile + "' successfully - returning response [" + response + "]..."));
        }
        return response;
    }

    public void deleteResource() throws Exception {
        DeploymentStatus removeStatus;
        String deploymentName;
        ProfileServiceConnection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting " + this.getResourceDescription() + "..."));
        }
        if ((connection = this.getConnection()) == null) {
            throw new Exception("No profile service connection available");
        }
        DeploymentManager deploymentManager = connection.getDeploymentManager();
        try {
            this.getManagedDeployment();
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot delete the deployment [" + this.getDeploymentKey() + "], since it no longer exists"));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping deployment [" + this.getDeploymentKey() + "]..."));
        }
        if ((deploymentName = this.getDeploymentName()) == null) {
            throw new IllegalStateException("Deployment " + this.getDeploymentKey() + " has vanished");
        }
        DeploymentProgress progress = deploymentManager.stop(new String[]{deploymentName});
        DeploymentStatus stopStatus = DeploymentUtils.run(progress);
        if (stopStatus.isFailed()) {
            LOG.error((Object)("Failed to stop deployment '" + deploymentName + "'."), (Throwable)stopStatus.getFailure());
            throw new Exception("Failed to stop deployment '" + deploymentName + "' - cause: " + stopStatus.getFailure());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing deployment [" + deploymentName + "]..."));
        }
        if ((removeStatus = DeploymentUtils.run(progress = deploymentManager.remove(new String[]{deploymentName}))).isFailed()) {
            LOG.error((Object)("Failed to remove deployment '" + deploymentName + "'."), (Throwable)removeStatus.getFailure());
            throw new Exception("Failed to remove deployment '" + deploymentName + "' - cause: " + removeStatus.getFailure());
        }
        ManagementView managementView = connection.getManagementView();
        managementView.load();
    }

    private DeployPackagesResponse failApplicationDeployment(String errorMessage, ResourcePackageDetails packageDetails) {
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.FAILURE);
        packageResponse.setErrorMessage(errorMessage);
        response.addPackageResponse(packageResponse);
        return response;
    }

    private void deleteTemporaryFile(File temporaryFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting temporary file '" + temporaryFile + "'..."));
        }
        try {
            FileUtils.forceDelete((File)temporaryFile);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to temporary file: " + temporaryFile));
        }
    }

    private File writeNewAppBitsToTempFile(ContentServices contentServices, ResourcePackageDetails packageDetails) throws Exception {
        File tempDir = new File(this.getResourceContext().getTemporaryDirectory(), "deploy" + UUID.randomUUID().getLeastSignificantBits());
        tempDir.mkdirs();
        File tempFile = new File(tempDir, this.deploymentFile.getName());
        OutputStream tempOutputStream = null;
        try {
            tempOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            long bytesWritten = contentServices.downloadPackageBits(this.getResourceContext().getContentContext(), packageDetails.getKey(), tempOutputStream, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Wrote " + bytesWritten + " bytes to '" + tempFile + "'."));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error writing updated application bits to temporary location: " + tempFile), (Throwable)e);
            throw e;
        }
        finally {
            if (tempOutputStream != null) {
                try {
                    tempOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing temporary output stream", (Throwable)e);
                }
            }
        }
        if (!tempFile.exists()) {
            LOG.error((Object)("Temporary file for application update not written to: " + tempFile));
            throw new Exception();
        }
        return tempFile;
    }
}

