/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public abstract class ClassAnnotationInformationFactory<A extends Annotation, T> {
    private final Class<A> annotationType;
    private final Class<?> multiAnnotationType;
    private final DotName annotationDotName;
    private final DotName multiAnnotationDotName;

    protected ClassAnnotationInformationFactory(Class<A> annotationType, Class<?> multiAnnotationType) {
        this.annotationType = annotationType;
        this.annotationDotName = DotName.createSimple((String)annotationType.getName());
        this.multiAnnotationType = multiAnnotationType;
        this.multiAnnotationDotName = multiAnnotationType != null ? DotName.createSimple((String)multiAnnotationType.getName()) : null;
    }

    public Map<String, ClassAnnotationInformation<A, T>> createAnnotationInformation(CompositeIndex index, boolean replacement) {
        List simpleAnnotations;
        ArrayList<TargetAnnotation> annotations = new ArrayList<TargetAnnotation>();
        if (this.multiAnnotationDotName != null) {
            for (AnnotationInstance multiInstance : index.getAnnotations(this.multiAnnotationDotName)) {
                annotations.addAll(this.fromMultiAnnotation(multiInstance));
            }
        }
        if ((simpleAnnotations = index.getAnnotations(this.annotationDotName)) != null) {
            for (AnnotationInstance annotation : simpleAnnotations) {
                annotations.add(new TargetAnnotation(annotation, annotation.target()));
            }
        }
        HashMap<DotName, ArrayList<TargetAnnotation>> classLevel = new HashMap<DotName, ArrayList<TargetAnnotation>>();
        HashMap methodLevel = new HashMap();
        HashMap fieldLevel = new HashMap();
        for (TargetAnnotation instance : annotations) {
            List<TargetAnnotation> data;
            DotName targetClass = this.getAnnotationClass(instance.target()).name();
            if (instance.target() instanceof ClassInfo) {
                data = (ArrayList<TargetAnnotation>)classLevel.get(targetClass);
                if (data == null) {
                    data = new ArrayList<TargetAnnotation>(1);
                    classLevel.put(targetClass, (ArrayList<TargetAnnotation>)data);
                }
                data.add(instance);
                continue;
            }
            if (instance.target() instanceof MethodInfo) {
                data = (List)methodLevel.get(targetClass);
                if (data == null) {
                    data = new ArrayList(1);
                    methodLevel.put(targetClass, data);
                }
                data.add(instance);
                continue;
            }
            if (instance.target() instanceof FieldInfo) {
                data = (List)fieldLevel.get(targetClass);
                if (data == null) {
                    data = new ArrayList(1);
                    fieldLevel.put(targetClass, data);
                }
                data.add(instance);
                continue;
            }
            if (instance.target() instanceof MethodParameterInfo) continue;
            throw EeMessages.MESSAGES.unknownAnnotationTargetType(instance.target());
        }
        HashMap<String, ClassAnnotationInformation<A, T>> ret = new HashMap<String, ClassAnnotationInformation<A, T>>();
        HashSet allClasses = new HashSet(classLevel.keySet());
        allClasses.addAll(methodLevel.keySet());
        allClasses.addAll(fieldLevel.keySet());
        for (DotName clazz : allClasses) {
            Map methodData;
            Map fieldData;
            List classData;
            List classAnnotations = (List)classLevel.get(clazz);
            if (classAnnotations == null) {
                classData = Collections.emptyList();
            } else {
                classData = new ArrayList(classAnnotations.size());
                for (TargetAnnotation instance : classAnnotations) {
                    classData.add(this.fromAnnotation(instance.instance(), replacement));
                }
            }
            List fieldAnnotations = (List)fieldLevel.get(clazz);
            if (fieldAnnotations == null) {
                fieldData = Collections.emptyMap();
            } else {
                fieldData = new HashMap();
                for (TargetAnnotation instance : fieldAnnotations) {
                    String name = ((FieldInfo)instance.target()).name();
                    List data = fieldData.get(name);
                    if (data == null) {
                        data = new ArrayList(1);
                        fieldData.put(name, data);
                    }
                    data.add(this.fromAnnotation(instance.instance(), replacement));
                }
            }
            List methodAnnotations = (List)methodLevel.get(clazz);
            if (methodAnnotations == null) {
                methodData = Collections.emptyMap();
            } else {
                methodData = new HashMap();
                for (TargetAnnotation instance : methodAnnotations) {
                    MethodIdentifier identifier = this.getMethodIdentifier(instance.target());
                    List data = methodData.get(identifier);
                    if (data == null) {
                        data = new ArrayList(1);
                        methodData.put(identifier, data);
                    }
                    data.add(this.fromAnnotation(instance.instance(), replacement));
                }
            }
            ClassAnnotationInformation information = new ClassAnnotationInformation(this.annotationType, classData, methodData, fieldData);
            ret.put(clazz.toString(), information);
        }
        return ret;
    }

    private ClassInfo getAnnotationClass(AnnotationTarget annotationTarget) {
        if (annotationTarget instanceof ClassInfo) {
            return (ClassInfo)annotationTarget;
        }
        if (annotationTarget instanceof MethodInfo) {
            return ((MethodInfo)annotationTarget).declaringClass();
        }
        if (annotationTarget instanceof FieldInfo) {
            return ((FieldInfo)annotationTarget).declaringClass();
        }
        if (annotationTarget instanceof MethodParameterInfo) {
            return ((MethodParameterInfo)annotationTarget).method().declaringClass();
        }
        throw EeMessages.MESSAGES.unknownAnnotationTargetType(annotationTarget);
    }

    protected abstract T fromAnnotation(AnnotationInstance var1, boolean var2);

    protected List<TargetAnnotation> fromMultiAnnotation(AnnotationInstance multiAnnotationInstance) {
        AnnotationInstance[] values;
        ArrayList<TargetAnnotation> instances = new ArrayList<TargetAnnotation>();
        for (AnnotationInstance value : values = multiAnnotationInstance.value().asNestedArray()) {
            instances.add(new TargetAnnotation(value, multiAnnotationInstance.target()));
        }
        return instances;
    }

    private MethodIdentifier getMethodIdentifier(AnnotationTarget target) {
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        String[] args = new String[methodInfo.args().length];
        for (int i = 0; i < methodInfo.args().length; ++i) {
            args[i] = methodInfo.args()[i].name().toString();
        }
        return MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])args);
    }

    public Class<A> getAnnotationType() {
        return this.annotationType;
    }

    public Class<?> getMultiAnnotationType() {
        return this.multiAnnotationType;
    }

    private static final class TargetAnnotation {
        private final AnnotationInstance instance;
        private final AnnotationTarget target;

        public TargetAnnotation(AnnotationInstance instance, AnnotationTarget target) {
            this.instance = instance;
            this.target = target;
        }

        public AnnotationInstance instance() {
            return this.instance;
        }

        public AnnotationTarget target() {
            return this.target;
        }
    }
}

