/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.builders;

import java.util.HashMap;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.FeatureNotSupportedException;

public abstract class CreateSequenceExprBuilder {
    public static final String KEY_SEQ_NAME = "SEQ_NAME";
    public static final String KEY_SEQ_START = "SEQ_START";
    public static final String KEY_SEQ_INCREMENT = "SEQ_INCREMENT";
    public static final String KEY_SEQ_CACHE_SIZE = "SEQ_CACHE_SIZE";
    public static final int USE_SEQID_NOCACHE_SIZE = 0;

    public static CreateSequenceExprBuilder getBuilder(DatabaseType type) {
        return CreateSequenceExprBuilder.getBuilder(type.getVendor());
    }

    public static CreateSequenceExprBuilder getBuilder(String type) {
        if ("oracle".equals(type)) {
            return new OracleInnerBuilder();
        }
        if ("sqlserver".equals(type)) {
            return new SqlServerInnerBuilder();
        }
        if ("postgresql".equals(type)) {
            return new PostgresInnerBuilder();
        }
        if ("h2".equals(type)) {
            return new H2InnerBuilder();
        }
        throw new UnsupportedOperationException("Cannot create a CREATE SEQUENCE builder for the requested database type: " + type);
    }

    public static int getSafeSequenceCacheSize(CreateSequenceExprBuilder builder, String requestedSize) {
        int size = 10;
        try {
            size = Integer.parseInt(requestedSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    public int getFactorySequenceCacheSize() {
        return 0;
    }

    protected String getSeqIdNoCacheLiteral() {
        return "";
    }

    protected String getSeqIdCacheLiteral() {
        return "CACHE";
    }

    protected abstract StringBuilder appendCreateSeqStem(HashMap<String, Object> var1, StringBuilder var2);

    protected StringBuilder appendSeqIdNoCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
        return builder.append(" ").append(this.getSeqIdNoCacheLiteral());
    }

    protected StringBuilder appendSeqIdCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
        return builder.append(" ").append(this.getSeqIdCacheLiteral()).append(" ").append(terms.get(KEY_SEQ_CACHE_SIZE));
    }

    protected StringBuilder appendCreateSeqCacheSize(HashMap<String, Object> terms, StringBuilder builder) {
        int specifiedCacheSize = (Integer)terms.get(KEY_SEQ_CACHE_SIZE);
        if (specifiedCacheSize >= 0) {
            if (0 == specifiedCacheSize) {
                this.appendSeqIdNoCacheTerms(terms, builder);
            } else {
                this.appendSeqIdCacheTerms(terms, builder);
            }
        }
        return builder;
    }

    public String build(HashMap<String, Object> terms) {
        StringBuilder builder = new StringBuilder();
        this.appendCreateSeqStem(terms, builder);
        this.appendCreateSeqCacheSize(terms, builder);
        return builder.toString();
    }

    private static class H2InnerBuilder
    extends CreateSequenceExprBuilder {
        private H2InnerBuilder() {
        }

        @Override
        public int getFactorySequenceCacheSize() {
            return 32;
        }

        @Override
        protected StringBuilder appendCreateSeqStem(HashMap<String, Object> terms, StringBuilder builder) {
            builder.append("CREATE SEQUENCE ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_NAME)).append(" START WITH ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_START)).append(" INCREMENT BY ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_INCREMENT));
            return builder;
        }

        @Override
        protected StringBuilder appendSeqIdNoCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
            terms.put(CreateSequenceExprBuilder.KEY_SEQ_CACHE_SIZE, 1);
            return this.appendSeqIdCacheTerms(terms, builder);
        }
    }

    private static class SqlServerInnerBuilder
    extends CreateSequenceExprBuilder {
        public static final String SEQ_SUFFIX = "_ID_SEQ";

        private SqlServerInnerBuilder() {
        }

        @Override
        public int getFactorySequenceCacheSize() {
            return 10;
        }

        @Override
        protected StringBuilder appendCreateSeqStem(HashMap<String, Object> terms, StringBuilder builder) {
            String name = ((String)terms.get(CreateSequenceExprBuilder.KEY_SEQ_NAME)).toUpperCase();
            if (!name.endsWith(SEQ_SUFFIX)) {
                throw new FeatureNotSupportedException("SQL Server does not support sequences, use identifier columns instead");
            }
            String tableName = name.substring(0, name.length() - SEQ_SUFFIX.length());
            builder.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ID IDENTITY( ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_START)).append(", ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_INCREMENT)).append(")");
            return builder;
        }

        @Override
        protected StringBuilder appendCreateSeqCacheSize(HashMap<String, Object> terms, StringBuilder builder) {
            return builder;
        }

        @Override
        protected StringBuilder appendSeqIdNoCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
            return builder;
        }
    }

    private static class OracleInnerBuilder
    extends CreateSequenceExprBuilder {
        private OracleInnerBuilder() {
        }

        @Override
        public int getFactorySequenceCacheSize() {
            return 32;
        }

        @Override
        protected StringBuilder appendCreateSeqStem(HashMap<String, Object> terms, StringBuilder builder) {
            builder.append("CREATE SEQUENCE ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_NAME)).append(" START WITH ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_START)).append(" INCREMENT BY ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_INCREMENT)).append(" NOMAXVALUE NOCYCLE");
            return builder;
        }

        @Override
        protected StringBuilder appendSeqIdNoCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
            return builder.append(" NOCACHE");
        }
    }

    private static class PostgresInnerBuilder
    extends CreateSequenceExprBuilder {
        private PostgresInnerBuilder() {
        }

        @Override
        public int getFactorySequenceCacheSize() {
            return 1;
        }

        @Override
        protected StringBuilder appendCreateSeqStem(HashMap<String, Object> terms, StringBuilder builder) {
            builder.append("CREATE SEQUENCE ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_NAME)).append(" START ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_START)).append(" INCREMENT ").append(terms.get(CreateSequenceExprBuilder.KEY_SEQ_INCREMENT));
            return builder;
        }

        @Override
        protected StringBuilder appendSeqIdNoCacheTerms(HashMap<String, Object> terms, StringBuilder builder) {
            terms.put(CreateSequenceExprBuilder.KEY_SEQ_CACHE_SIZE, 1);
            return this.appendSeqIdCacheTerms(terms, builder);
        }
    }
}

