/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest.calltime;

import java.util.Date;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.plugins.perftest.calltime.CalltimeFactory;
import org.rhq.plugins.perftest.scenario.ConfigurableCallTimeDataGenerator;

public class ConfigurableCallTimeDataFactory
implements CalltimeFactory {
    private ConfigurableCallTimeDataGenerator generator;

    public ConfigurableCallTimeDataFactory(ConfigurableCallTimeDataGenerator generator) {
        this.generator = generator;
    }

    @Override
    public CallTimeData nextValue(MeasurementScheduleRequest request) {
        int minMsgCount = this.generator.getMinMsgCount();
        int maxMsgCount = this.generator.getMaxMsgCount();
        int numSubPath = this.generator.getNumberSubPaths();
        int minDuration = this.generator.getMinDuration();
        int maxDuration = this.generator.getMaxDuration();
        String id = String.valueOf(request.getScheduleId());
        CallTimeData data = new CallTimeData(request);
        int countInterval = (int)((double)(maxMsgCount - minMsgCount) * Math.random());
        for (int count = 0; count < minMsgCount + countInterval; ++count) {
            long duration = (long)((double)minDuration + Math.random() * (double)(maxDuration - minDuration));
            String path = "/base/" + id;
            if (numSubPath > 0) {
                path = path + "/" + (int)(Math.random() * (double)numSubPath);
            }
            data.addCallData(path, new Date(), duration);
        }
        return data;
    }
}

