/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi.factories;

import java.net.URI;
import java.net.URISyntaxException;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentManagerImpl;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    private static String DISPLAY_NAME;
    private static String PRODUCT_VERSION;

    public static synchronized void register() {
    }

    public boolean handlesURI(String uri) {
        boolean handlesURI = uri.startsWith("http://org.jboss.as.ee.deployment/jsr88");
        DeploymentLogger.ROOT_LOGGER.debugf("handlesURI [%s]: %s", uri, handlesURI);
        return handlesURI;
    }

    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        DeploymentLogger.ROOT_LOGGER.debugf("getDeploymentManager (uri=%s)", uri);
        try {
            URI deployURI = this.parseURI(uri);
            return new DeploymentManagerImpl(deployURI, true, userName, password);
        }
        catch (URISyntaxException e) {
            DeploymentManagerCreationException ex = new DeploymentManagerCreationException("Failed to create DeploymentManagerImpl");
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        DeploymentLogger.ROOT_LOGGER.debugf("getDisconnectedDeploymentManager (uri=%s)", uri);
        try {
            URI deployURI = this.parseURI(uri);
            return new DeploymentManagerImpl(deployURI, false);
        }
        catch (URISyntaxException e) {
            DeploymentManagerCreationException ex = new DeploymentManagerCreationException("Failed to create DeploymentManagerImpl");
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    private URI parseURI(String uri) throws URISyntaxException {
        URI deployURI = new URI(uri);
        return deployURI;
    }

    static {
        DeploymentFactoryManager manager = DeploymentFactoryManager.getInstance();
        manager.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
        Package pkg = DeploymentFactoryImpl.class.getPackage();
        if (pkg != null) {
            DISPLAY_NAME = pkg.getImplementationVendor();
            PRODUCT_VERSION = pkg.getImplementationVersion();
        }
        if (DISPLAY_NAME == null || PRODUCT_VERSION == null) {
            DISPLAY_NAME = "DeploymentFactoryImpl";
            PRODUCT_VERSION = "1.1-DEV";
        }
    }
}

