/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.JBossAppenderHandler;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.LogContext;

public class Category
implements AppenderAttachable {
    private static final Object LEVEL_LOCK = new Object();
    private static final String FQCN = Category.class.getName();
    protected volatile Level level;
    protected volatile Category parent;
    final org.jboss.logmanager.Logger jblmLogger;

    protected Category(String name) {
        this.jblmLogger = JBossLogManagerFacade.getJBossLogger(LogContext.getLogContext(), name);
    }

    @Override
    public void addAppender(Appender newAppender) {
        JBossAppenderHandler.attachAppender(this.jblmLogger, newAppender);
        this.getLoggerRepository().fireAddAppenderEvent(this, newAppender);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void callAppenders(LoggingEvent event) {
        this.jblmLogger.logRaw(event.getLogRecord());
    }

    org.jboss.logmanager.Logger getJBossLogger() {
        return this.jblmLogger;
    }

    void closeNestedAppenders() {
        JBossAppenderHandler.closeAppenders(this.jblmLogger);
    }

    public void debug(Object message) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.DEBUG)) {
            this.forcedLog(FQCN, Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.DEBUG)) {
            this.forcedLog(FQCN, Level.DEBUG, message, t);
        }
    }

    public void error(Object message) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.ERROR)) {
            this.forcedLog(FQCN, Level.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.ERROR)) {
            this.forcedLog(FQCN, Level.ERROR, message, t);
        }
    }

    public static Logger exists(String name) {
        return LogManager.exists(name);
    }

    public void fatal(Object message) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.FATAL)) {
            this.forcedLog(FQCN, Level.FATAL, message, null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.FATAL)) {
            this.forcedLog(FQCN, Level.FATAL, message, t);
        }
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        this.callAppenders(new LoggingEvent(fqcn, this, level, message, t));
    }

    public boolean getAdditivity() {
        return this.jblmLogger.getUseParentHandlers();
    }

    @Override
    public Enumeration getAllAppenders() {
        List<Appender> appenders = JBossAppenderHandler.getAppenders(this.jblmLogger);
        if (appenders.isEmpty()) {
            return NullEnumeration.getInstance();
        }
        return Collections.enumeration(appenders);
    }

    @Override
    public Appender getAppender(String name) {
        return JBossAppenderHandler.getAppender(this.jblmLogger, name);
    }

    public Level getEffectiveLevel() {
        return JBossLevelMapping.getPriorityFor(this.jblmLogger.getEffectiveLevel());
    }

    @Deprecated
    public Priority getChainedPriority() {
        return this.getEffectiveLevel();
    }

    public static Enumeration getCurrentCategories() {
        return LogManager.getCurrentLoggers();
    }

    @Deprecated
    public static LoggerRepository getDefaultHierarchy() {
        return LogManager.getLoggerRepository();
    }

    @Deprecated
    public LoggerRepository getHierarchy() {
        return this.getLoggerRepository();
    }

    public LoggerRepository getLoggerRepository() {
        return LogManager.getLoggerRepository();
    }

    @Deprecated
    public static Category getInstance(String name) {
        return LogManager.getLogger(name);
    }

    @Deprecated
    public static Category getInstance(Class clazz) {
        return LogManager.getLogger(clazz);
    }

    public final String getName() {
        return this.jblmLogger.getName();
    }

    public final Category getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Level getLevel() {
        Object object = LEVEL_LOCK;
        synchronized (object) {
            Level currentLevel;
            if (this.level != null && (currentLevel = JBossLevelMapping.getPriorityFor(this.jblmLogger.getLevel())).toInt() != this.level.toInt()) {
                this.jblmLogger.setLevel(JBossLevelMapping.getLevelFor(this.level));
            }
        }
        return this.level;
    }

    @Deprecated
    public final Level getPriority() {
        return this.getLevel();
    }

    @Deprecated
    public static Category getRoot() {
        return LogManager.getRootLogger();
    }

    public ResourceBundle getResourceBundle() {
        return this.jblmLogger.getResourceBundle();
    }

    protected String getResourceBundleString(String key) {
        ResourceBundle rb = this.getResourceBundle();
        if (rb == null) {
            return null;
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException mre) {
            this.error("No resource is associated with key \"" + key + "\".");
            return null;
        }
    }

    public void info(Object message) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.INFO)) {
            this.forcedLog(FQCN, Level.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.INFO)) {
            this.forcedLog(FQCN, Level.INFO, message, t);
        }
    }

    @Override
    public boolean isAttached(Appender appender) {
        return JBossAppenderHandler.isAppenderAttached(this.jblmLogger, appender);
    }

    public boolean isDebugEnabled() {
        return this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.DEBUG);
    }

    public boolean isEnabledFor(Priority level) {
        return this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(level));
    }

    public boolean isInfoEnabled() {
        return this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.INFO);
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        if (this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(priority))) {
            String msg = this.getResourceBundleString(key);
            if (msg == null) {
                msg = key;
            }
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        if (this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(priority))) {
            String pattern = this.getResourceBundleString(key);
            String msg = pattern == null ? key : MessageFormat.format(pattern, params);
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(priority))) {
            this.forcedLog(FQCN, priority, message, t);
        }
    }

    public void log(Priority priority, Object message) {
        if (this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(priority))) {
            this.forcedLog(FQCN, priority, message, null);
        }
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        if (this.jblmLogger.isLoggable(JBossLevelMapping.getLevelFor(level))) {
            this.forcedLog(callerFQCN, level, message, t);
        }
    }

    private void fireRemoveAppenderEvent(LoggerRepository repository, Appender appender) {
        if (appender != null) {
            if (repository instanceof Hierarchy) {
                ((Hierarchy)repository).fireRemoveAppenderEvent(this, appender);
            } else if (repository instanceof HierarchyEventListener) {
                ((HierarchyEventListener)((Object)repository)).removeAppenderEvent(this, appender);
            }
        }
    }

    @Override
    public void removeAllAppenders() {
        List<Appender> removedAppenders = JBossAppenderHandler.removeAllAppenders(this.jblmLogger);
        LoggerRepository repository = this.getLoggerRepository();
        for (Appender appender : removedAppenders) {
            this.fireRemoveAppenderEvent(repository, appender);
        }
    }

    @Override
    public void removeAppender(Appender appender) {
        if (appender != null && JBossAppenderHandler.removeAppender(this.jblmLogger, appender)) {
            this.fireRemoveAppenderEvent(this.getLoggerRepository(), appender);
        }
    }

    @Override
    public void removeAppender(String name) {
        if (name != null) {
            this.removeAppender(JBossAppenderHandler.getAppender(this.jblmLogger, name));
        }
    }

    public void setAdditivity(boolean additive) {
        this.jblmLogger.setUseParentHandlers(additive);
    }

    final void setHierarchy(LoggerRepository repository) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) {
        Object object = LEVEL_LOCK;
        synchronized (object) {
            this.jblmLogger.setLevel(JBossLevelMapping.getLevelFor(level));
            this.level = level;
        }
    }

    public void setPriority(Priority priority) {
        this.setLevel((Level)priority);
    }

    public void setResourceBundle(ResourceBundle bundle) {
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public void warn(Object message) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.WARN)) {
            this.forcedLog(FQCN, Level.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.jblmLogger.isLoggable((java.util.logging.Level)org.jboss.logmanager.Level.WARN)) {
            this.forcedLog(FQCN, Level.WARN, message, t);
        }
    }
}

