/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.safeinvoker;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;

public class HibernateDetachUtility {
    private static final Log LOG;
    static HashCodeGenerator hashCodeGenerator;
    private static final String DEPTH_ALLOWED_SYSPROP = "rhq.server.hibernate-detach-utility.depth-allowed";
    private static final String THROW_EXCEPTION_ON_DEPTH_LIMIT_SYSPROP = "rhq.server.hibernate-detach-utility.throw-exception-on-depth-limit";
    private static final int depthAllowed;
    private static final boolean throwExceptionOnDepthLimit;
    private static final String DUMP_STACK_THRESHOLDS_SYSPROP = "rhq.server.hibernate-detach-utility.dump-stack-thresholds";
    private static final boolean dumpStackOnThresholdLimit;
    private static final long millisThresholdLimit;
    private static final int sizeThresholdLimit;

    public static void nullOutUninitializedFields(Object value, SerializationType serializationType) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<Integer, Object> checkedObjectMap = new HashMap<Integer, Object>();
        HashMap<Integer, List<Object>> checkedObjectCollisionMap = new HashMap<Integer, List<Object>>();
        HibernateDetachUtility.nullOutUninitializedFields(value, checkedObjectMap, checkedObjectCollisionMap, 0, serializationType);
        long duration = System.currentTimeMillis() - start;
        if (dumpStackOnThresholdLimit) {
            int numObjectsProcessed = checkedObjectMap.size();
            if (duration > millisThresholdLimit || numObjectsProcessed > sizeThresholdLimit) {
                String rootObjectString = value != null ? value.getClass().toString() : "null";
                LOG.warn((Object)("Detached [" + numObjectsProcessed + "] objects in [" + duration + "]ms from root object [" + rootObjectString + "]"), new Throwable("HIBERNATE DETACH UTILITY STACK TRACE"));
            }
        } else if (duration > 10000L && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Detached [" + checkedObjectMap.size() + "] objects in [" + duration + "]ms"));
        }
        checkedObjectMap.clear();
        checkedObjectCollisionMap.clear();
    }

    private static void nullOutUninitializedFields(Object value, Map<Integer, Object> checkedObjectMap, Map<Integer, List<Object>> checkedObjectCollisionMap, int depth, SerializationType serializationType) throws Exception {
        if (depth > depthAllowed) {
            String warningMessage = "Recursed too deep [" + depth + " > " + depthAllowed + "], will not attempt to detach object of type [" + (value != null ? value.getClass().getName() : "N/A") + "]. This may cause serialization errors later. " + "You can try to work around this by setting the system property [" + DEPTH_ALLOWED_SYSPROP + "] to a value higher than [" + depth + "] or you can set the system property [" + THROW_EXCEPTION_ON_DEPTH_LIMIT_SYSPROP + "] to 'false'";
            LOG.warn((Object)warningMessage);
            if (throwExceptionOnDepthLimit) {
                throw new IllegalStateException(warningMessage);
            }
            return;
        }
        if (null == value) {
            return;
        }
        Integer valueIdentity = hashCodeGenerator.getHashCode(value);
        Object checkedObject = checkedObjectMap.get(valueIdentity);
        if (null == checkedObject) {
            checkedObjectMap.put(valueIdentity, value);
        } else {
            if (value == checkedObject) {
                return;
            }
            boolean alreadyDetached = false;
            List<Object> collisionObjects = checkedObjectCollisionMap.get(valueIdentity);
            if (null == collisionObjects) {
                collisionObjects = new ArrayList<Object>(1);
                checkedObjectCollisionMap.put(valueIdentity, collisionObjects);
            } else {
                for (Object collisionObject : collisionObjects) {
                    if (value != collisionObject) continue;
                    alreadyDetached = true;
                    break;
                }
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder message = new StringBuilder("\n\tIDENTITY HASHCODE COLLISION [hash=");
                message.append(valueIdentity);
                message.append(", alreadyDetached=");
                message.append(alreadyDetached);
                message.append("]");
                message.append("\n\tCurrent  : ");
                message.append(value.getClass().getName());
                message.append("\n\t    ");
                message.append(value);
                message.append("\n\tPrevious : ");
                message.append(checkedObject.getClass().getName());
                message.append("\n\t    ");
                message.append(checkedObject);
                for (Object collisionObject : collisionObjects) {
                    message.append("\n\tPrevious : ");
                    message.append(collisionObject.getClass().getName());
                    message.append("\n\t    ");
                    message.append(collisionObject);
                }
                LOG.debug((Object)message);
            }
            if (alreadyDetached) {
                return;
            }
            collisionObjects.add(value);
        }
        if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            for (int i = 0; i < objArray.length; ++i) {
                Object listEntry = objArray[i];
                Object replaceEntry = HibernateDetachUtility.replaceObject(listEntry);
                if (replaceEntry != null) {
                    objArray[i] = replaceEntry;
                }
                HibernateDetachUtility.nullOutUninitializedFields(objArray[i], checkedObjectMap, checkedObjectCollisionMap, depth + 1, serializationType);
            }
        } else if (value instanceof List) {
            ListIterator<Object> i = ((List)value).listIterator();
            while (i.hasNext()) {
                Object val = i.next();
                Object replace = HibernateDetachUtility.replaceObject(val);
                if (replace != null) {
                    val = replace;
                    i.set(replace);
                }
                HibernateDetachUtility.nullOutUninitializedFields(val, checkedObjectMap, checkedObjectCollisionMap, depth + 1, serializationType);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList itemsToBeReplaced = new ArrayList();
            ArrayList<Object> replacementItems = new ArrayList<Object>();
            for (Object item : collection) {
                Object replacementItem = HibernateDetachUtility.replaceObject(item);
                if (replacementItem != null) {
                    itemsToBeReplaced.add(item);
                    replacementItems.add(replacementItem);
                    item = replacementItem;
                }
                HibernateDetachUtility.nullOutUninitializedFields(item, checkedObjectMap, checkedObjectCollisionMap, depth + 1, serializationType);
            }
            collection.removeAll(itemsToBeReplaced);
            collection.addAll(replacementItems);
        } else if (value instanceof Map) {
            Map originalMap = (Map)value;
            HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
            Iterator i = originalMap.keySet().iterator();
            while (i.hasNext()) {
                Object originalKey = i.next();
                Object originalKeyValue = originalMap.get(originalKey);
                Object replaceKey = HibernateDetachUtility.replaceObject(originalKey);
                Object replaceValue = HibernateDetachUtility.replaceObject(originalKeyValue);
                if (replaceKey == null && replaceValue == null) continue;
                Object newKey = replaceKey != null ? replaceKey : originalKey;
                Object newValue = replaceValue != null ? replaceValue : originalKeyValue;
                replaceMap.put(newKey, newValue);
                i.remove();
            }
            originalMap.putAll(replaceMap);
            for (Object key : originalMap.keySet()) {
                HibernateDetachUtility.nullOutUninitializedFields(originalMap.get(key), checkedObjectMap, checkedObjectCollisionMap, depth + 1, serializationType);
                HibernateDetachUtility.nullOutUninitializedFields(key, checkedObjectMap, checkedObjectCollisionMap, depth + 1, serializationType);
            }
        } else if (value instanceof Enum) {
            return;
        }
        if (serializationType == SerializationType.JAXB) {
            XmlAccessorType at = value.getClass().getAnnotation(XmlAccessorType.class);
            if (at != null && at.value() == XmlAccessType.FIELD) {
                HibernateDetachUtility.nullOutFieldsByFieldAccess(value, checkedObjectMap, checkedObjectCollisionMap, depth, serializationType);
            } else {
                HibernateDetachUtility.nullOutFieldsByAccessors(value, checkedObjectMap, checkedObjectCollisionMap, depth, serializationType);
            }
        } else if (serializationType == SerializationType.SERIALIZATION) {
            HibernateDetachUtility.nullOutFieldsByFieldAccess(value, checkedObjectMap, checkedObjectCollisionMap, depth, serializationType);
        }
    }

    private static void nullOutFieldsByFieldAccess(Object object, Map<Integer, Object> checkedObjects, Map<Integer, List<Object>> checkedObjectCollisionMap, int depth, SerializationType serializationType) throws Exception {
        ArrayList<Field> fieldsToClean = new ArrayList<Field>();
        for (Class<?> tmpClass = object.getClass(); tmpClass != null && tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = tmpClass.getDeclaredFields()) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                fieldsToClean.add(declaredField);
            }
        }
        HibernateDetachUtility.nullOutFieldsByFieldAccess(object, fieldsToClean, checkedObjects, checkedObjectCollisionMap, depth, serializationType);
    }

    private static void nullOutFieldsByFieldAccess(Object object, List<Field> classFields, Map<Integer, Object> checkedObjects, Map<Integer, List<Object>> checkedObjectCollisionMap, int depth, SerializationType serializationType) throws Exception {
        boolean accessModifierFlag = false;
        for (Field field : classFields) {
            AbstractCollection replacement;
            Object fieldValue;
            accessModifierFlag = false;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                accessModifierFlag = true;
            }
            if ((fieldValue = field.get(object)) instanceof HibernateProxy) {
                replacement = null;
                String assistClassName = fieldValue.getClass().getName();
                if (assistClassName.contains("jvst") || assistClassName.contains("EnhancerByCGLIB")) {
                    Class<?> assistClass = fieldValue.getClass();
                    try {
                        Method m = assistClass.getMethod("writeReplace", new Class[0]);
                        replacement = m.invoke(fieldValue, new Object[0]);
                        String assistNameDelimiter = assistClassName.contains("jvst") ? "_$$_" : "$$";
                        assistClassName = assistClassName.substring(0, assistClassName.indexOf(assistNameDelimiter));
                        if (replacement != null && !replacement.getClass().getName().contains("hibernate")) {
                            HibernateDetachUtility.nullOutUninitializedFields(replacement, checkedObjects, checkedObjectCollisionMap, depth + 1, serializationType);
                            field.set(object, replacement);
                        } else {
                            replacement = null;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to write replace object " + fieldValue.getClass()), (Throwable)e);
                    }
                }
                if (replacement == null) {
                    String className = ((HibernateProxy)fieldValue).getHibernateLazyInitializer().getEntityName();
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = contextClassLoader == null ? Class.forName(className) : Class.forName(className, true, contextClassLoader);
                    Class[] constArgs = new Class[]{Integer.class};
                    Constructor<?> construct = null;
                    try {
                        construct = clazz.getConstructor(constArgs);
                        replacement = construct.newInstance((Integer)((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        field.set(object, replacement);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            Field idField = clazz.getDeclaredField("id");
                            Constructor<?> ct = clazz.getDeclaredConstructor(new Class[0]);
                            ct.setAccessible(true);
                            replacement = ct.newInstance(new Object[0]);
                            if (!idField.isAccessible()) {
                                idField.setAccessible(true);
                            }
                            idField.set(replacement, ((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LOG.error((Object)("No id constructor and unable to set field id for base bean " + className), (Throwable)e);
                        }
                        field.set(object, replacement);
                    }
                }
            } else if (fieldValue instanceof PersistentCollection) {
                if (!((PersistentCollection)fieldValue).wasInitialized()) {
                    field.set(object, null);
                } else {
                    replacement = null;
                    boolean needToNullOutFields = true;
                    if (fieldValue instanceof Map) {
                        replacement = new HashMap((Map)fieldValue);
                    } else if (fieldValue instanceof List) {
                        replacement = new ArrayList((List)fieldValue);
                    } else if (fieldValue instanceof Set) {
                        ArrayList l = new ArrayList((Set)fieldValue);
                        HibernateDetachUtility.nullOutUninitializedFields(l, checkedObjects, checkedObjectCollisionMap, depth + 1, serializationType);
                        replacement = new HashSet(l);
                        needToNullOutFields = false;
                    } else if (fieldValue instanceof Collection) {
                        replacement = new ArrayList((Collection)fieldValue);
                    }
                    HibernateDetachUtility.setField(object, field.getName(), replacement);
                    if (needToNullOutFields) {
                        HibernateDetachUtility.nullOutUninitializedFields(replacement, checkedObjects, checkedObjectCollisionMap, depth + 1, serializationType);
                    }
                }
            } else if (fieldValue != null && (fieldValue.getClass().getName().contains("org.rhq") || fieldValue instanceof Collection || fieldValue instanceof Object[] || fieldValue instanceof Map)) {
                HibernateDetachUtility.nullOutUninitializedFields(fieldValue, checkedObjects, checkedObjectCollisionMap, depth + 1, serializationType);
            }
            if (!accessModifierFlag) continue;
            field.setAccessible(false);
        }
    }

    private static Object replaceObject(Object object) {
        Object replacement = null;
        if (object instanceof HibernateProxy && object.getClass().getName().contains("jvst")) {
            Class<?> assistClass = object.getClass();
            try {
                Method m = assistClass.getMethod("writeReplace", new Class[0]);
                replacement = m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to write replace object " + object.getClass()), (Throwable)e);
            }
        }
        return replacement;
    }

    private static void nullOutFieldsByAccessors(Object value, Map<Integer, Object> checkedObjects, Map<Integer, List<Object>> checkedObjectCollisionMap, int depth, SerializationType serializationType) throws Exception {
        PropertyDescriptor[] pds;
        BeanInfo bi = Introspector.getBeanInfo(value.getClass(), Object.class);
        for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
            Object propertyValue;
            block8: {
                propertyValue = null;
                try {
                    propertyValue = pd.getReadMethod().invoke(value, new Object[0]);
                }
                catch (Throwable lie) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)("Couldn't load: " + pd.getName() + " off of " + value.getClass().getSimpleName()), lie);
                }
            }
            if (!Hibernate.isInitialized((Object)propertyValue)) {
                try {
                    Method writeMethod;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Nulling out: " + pd.getName() + " off of " + value.getClass().getSimpleName()));
                    }
                    if ((writeMethod = pd.getWriteMethod()) != null && writeMethod.getAnnotation(XmlTransient.class) == null) {
                        pd.getWriteMethod().invoke(value, new Object[]{null});
                        continue;
                    }
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                catch (Exception lie) {
                    LOG.debug((Object)("Couldn't null out: " + pd.getName() + " off of " + value.getClass().getSimpleName() + " trying field access"), (Throwable)lie);
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                continue;
            }
            if (!(propertyValue instanceof Collection) && (propertyValue == null || !propertyValue.getClass().getName().startsWith("org.rhq.core.domain"))) continue;
            HibernateDetachUtility.nullOutUninitializedFields(propertyValue, checkedObjects, checkedObjectCollisionMap, depth + 1, serializationType);
        }
    }

    private static void setField(Object object, String fieldName, Object newValue) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(object, newValue);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void nullOutField(Object value, String fieldName) {
        try {
            Field f = value.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(value, null);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static {
        int tmp_sizeThresholdLimit;
        long tmp_millisThresholdLimit;
        boolean tmp_dumpStackOnThresholdLimit;
        boolean booleanValue;
        int value;
        LOG = LogFactory.getLog(HibernateDetachUtility.class);
        hashCodeGenerator = new SystemHashCodeGenerator();
        try {
            String str = System.getProperty(DEPTH_ALLOWED_SYSPROP, "100");
            value = Integer.parseInt(str);
        }
        catch (Throwable t) {
            value = 100;
        }
        depthAllowed = value;
        try {
            String str = System.getProperty(THROW_EXCEPTION_ON_DEPTH_LIMIT_SYSPROP, "true");
            booleanValue = Boolean.parseBoolean(str);
        }
        catch (Throwable t) {
            booleanValue = true;
        }
        throwExceptionOnDepthLimit = booleanValue;
        String prop = null;
        try {
            prop = System.getProperty(DUMP_STACK_THRESHOLDS_SYSPROP);
            if (prop != null) {
                String[] nums = prop.split(":");
                tmp_dumpStackOnThresholdLimit = true;
                tmp_millisThresholdLimit = Long.parseLong(nums[0]);
                tmp_sizeThresholdLimit = Integer.parseInt(nums[1]);
            } else {
                tmp_dumpStackOnThresholdLimit = false;
                tmp_millisThresholdLimit = Long.MAX_VALUE;
                tmp_sizeThresholdLimit = Integer.MAX_VALUE;
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Bad value for [rhq.server.hibernate-detach-utility.dump-stack-thresholds]=[" + prop + "]: " + t.toString()));
            tmp_dumpStackOnThresholdLimit = true;
            tmp_millisThresholdLimit = 5000L;
            tmp_sizeThresholdLimit = 10000;
        }
        dumpStackOnThresholdLimit = tmp_dumpStackOnThresholdLimit;
        millisThresholdLimit = tmp_millisThresholdLimit;
        sizeThresholdLimit = tmp_sizeThresholdLimit;
    }

    static class SystemHashCodeGenerator
    implements HashCodeGenerator {
        SystemHashCodeGenerator() {
        }

        @Override
        public Integer getHashCode(Object value) {
            return System.identityHashCode(value);
        }
    }

    static interface HashCodeGenerator {
        public Integer getHashCode(Object var1);
    }

    public static enum SerializationType {
        SERIALIZATION,
        JAXB;

    }
}

