/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Map;
import java.util.Set;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    private final boolean propagateSecurity;

    public SecurityContextInterceptorFactory() {
        this.propagateSecurity = true;
    }

    public SecurityContextInterceptorFactory(boolean propagateSecurity) {
        this.propagateSecurity = propagateSecurity;
    }

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        Object securityManager = this.propagateSecurity ? ejbComponent.getSecurityManager() : new SimpleSecurityManager((SimpleSecurityManager)ejbComponent.getSecurityManager());
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomain = securityMetaData.getSecurityDomain();
        if (securityDomain == null) {
            throw EjbMessages.MESSAGES.invalidSecurityForDomainSet(ejbComponent.getComponentName());
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomain + " for EJB " + ejbComponent.getComponentName());
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = securityMetaData.getRunAsPrincipal();
        SecurityRolesMetaData securityRoles = securityMetaData.getSecurityRoles();
        Set extraRoles = null;
        Map principalVsRolesMap = null;
        if (securityRoles != null) {
            principalVsRolesMap = securityRoles.getPrincipalVersusRolesMap();
            if (runAsPrincipal != null) {
                extraRoles = securityRoles.getSecurityRoleNamesByPrincipal(runAsPrincipal);
            }
        }
        SecurityContextInterceptorHolder holder = new SecurityContextInterceptorHolder();
        holder.setSecurityManager((ServerSecurityManager)securityManager).setSecurityDomain(securityDomain).setRunAs(runAs).setRunAsPrincipal(runAsPrincipal).setExtraRoles(extraRoles).setPrincipalVsRolesMap(principalVsRolesMap);
        return new SecurityContextInterceptor(holder);
    }
}

