/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBAccessException;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.security.SecurityRolesAssociation;

public class SecurityContextInterceptor
implements Interceptor {
    private final PrivilegedAction<Void> pushAction;
    private final PrivilegedAction<Void> popAction;

    public SecurityContextInterceptor(final SecurityContextInterceptorHolder holder) {
        this.pushAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    holder.securityManager.push(holder.securityDomain, holder.runAs, holder.runAsPrincipal, holder.extraRoles);
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(holder.principalVsRolesMap);
                    }
                }
                catch (SecurityException e) {
                    throw new EJBAccessException(e.getMessage());
                }
                return null;
            }
        };
        this.popAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                holder.securityManager.pop();
                if (holder.principalVsRolesMap != null) {
                    SecurityRolesAssociation.setSecurityRoles(null);
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean securityManager;
        boolean bl = securityManager = System.getSecurityManager() != null;
        if (securityManager) {
            AccessController.doPrivileged(this.pushAction);
        } else {
            this.pushAction.run();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (securityManager) {
                AccessController.doPrivileged(this.popAction);
            } else {
                this.popAction.run();
            }
        }
    }
}

