/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.Random;
import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.logging.Logger;

public class LocalEJBReceiverPreferringDeploymentNodeSelector
implements DeploymentNodeSelector {
    private static final Logger logger = Logger.getLogger(LocalEJBReceiverPreferringDeploymentNodeSelector.class);
    private final String localNodeName = SecurityActions.getSystemProperty("jboss.node.name");

    public String selectNode(String[] eligibleNodes, String appName, String moduleName, String distinctName) {
        if (eligibleNodes.length == 1) {
            return eligibleNodes[0];
        }
        for (String eligibleNode : eligibleNodes) {
            if (!this.localNodeName.equals(eligibleNode)) continue;
            logger.debug((Object)("Selected local node " + this.localNodeName + " for [app: " + appName + ", module: " + moduleName + ",  distinctname: " + distinctName + "]"));
            return eligibleNode;
        }
        Random random = new Random();
        int randomSelection = random.nextInt(eligibleNodes.length);
        return eligibleNodes[randomSelection];
    }
}

