/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.TransactionAttributeType;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenAllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstance;
import org.jboss.as.ejb3.component.messagedriven.SecurityActions;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.inflow.JBossMessageEndpointFactory;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.jca.core.spi.rar.Endpoint;

public class MessageDrivenComponent
extends EJBComponent
implements PooledComponent<MessageDrivenComponentInstance> {
    private final Pool<MessageDrivenComponentInstance> pool;
    private final String poolName;
    private final ActivationSpec activationSpec;
    private final MessageEndpointFactory endpointFactory;
    private final Class<?> messageListenerInterface;
    private final ClassLoader classLoader;
    private volatile boolean deliveryActive;
    private ResourceAdapter resourceAdapter;
    private Endpoint endpoint;

    protected MessageDrivenComponent(final MessageDrivenComponentCreateService ejbComponentCreateService, final Class<?> messageListenerInterface, ActivationSpec activationSpec, boolean deliveryActive) {
        super(ejbComponentCreateService);
        StatelessObjectFactory<MessageDrivenComponentInstance> factory = new StatelessObjectFactory<MessageDrivenComponentInstance>(){

            @Override
            public MessageDrivenComponentInstance create() {
                return (MessageDrivenComponentInstance)MessageDrivenComponent.this.createInstance();
            }

            @Override
            public void destroy(MessageDrivenComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = ejbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debug("Pooling is disabled for MDB " + ejbComponentCreateService.getComponentName());
            this.pool = null;
            this.poolName = null;
        } else {
            EjbLogger.ROOT_LOGGER.debug("Using pool config " + poolConfig + " to create pool for MDB " + ejbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
            this.poolName = poolConfig.getPoolName();
        }
        this.classLoader = ejbComponentCreateService.getModuleClassLoader();
        this.activationSpec = activationSpec;
        this.messageListenerInterface = messageListenerInterface;
        ClassLoader componentClassLoader = ejbComponentCreateService.getComponentClass().getClassLoader();
        MessageEndpointService<Object> service = new MessageEndpointService<Object>(){

            @Override
            public Class<Object> getMessageListenerInterface() {
                return messageListenerInterface;
            }

            @Override
            public TransactionManager getTransactionManager() {
                return MessageDrivenComponent.this.getTransactionManager();
            }

            @Override
            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                if (MessageDrivenComponent.this.isBeanManagedTransaction()) {
                    return false;
                }
                return MessageDrivenComponent.this.getTransactionAttributeType(MethodIntf.BEAN, method) == TransactionAttributeType.REQUIRED;
            }

            @Override
            public Object obtain(long timeout, TimeUnit unit) {
                return MessageDrivenComponent.this.createViewInstanceProxy(messageListenerInterface, Collections.emptyMap());
            }

            @Override
            public void release(Object obj) {
            }

            @Override
            public ClassLoader getClassLoader() {
                return ejbComponentCreateService.getComponentClass().getClassLoader();
            }
        };
        this.endpointFactory = new JBossMessageEndpointFactory(componentClassLoader, service);
        this.deliveryActive = deliveryActive;
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        return new MessageDrivenComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Pool<MessageDrivenComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    protected void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void start() {
        if (this.endpoint == null) {
            throw EjbMessages.MESSAGES.endpointUnAvailable(this.getComponentName());
        }
        this.getShutDownInterceptorFactory().start();
        super.start();
        if (this.deliveryActive) {
            this.activate();
        }
        if (this.pool != null) {
            this.pool.start();
        }
    }

    @Override
    public void stop() {
        this.deactivate();
        this.deliveryActive = false;
        this.getShutDownInterceptorFactory().shutdown();
        if (this.pool != null) {
            this.pool.stop();
        }
        super.stop();
    }

    private void activate() {
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.classLoader);
            this.endpoint.activate(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
        }
    }

    private void deactivate() {
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.classLoader);
            this.endpoint.deactivate(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException re) {
            throw EjbMessages.MESSAGES.failureDuringEndpointDeactivation(this.getComponentName(), re);
        }
        finally {
            SecurityActions.setContextClassLoader(oldTccl);
        }
    }

    public void startDelivery() {
        this.deliveryActive = true;
        this.activate();
    }

    public void stopDelivery() {
        this.deactivate();
        this.deliveryActive = false;
    }

    public boolean isDeliveryActive() {
        return this.deliveryActive;
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return MessageDrivenAllowedMethodsInformation.INSTANCE;
    }
}

