/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.interceptors.AsyncInvocationTask;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.interceptors.SecurityActions;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.plugins.JBossSecurityContext;

public final class AsyncFutureInterceptorFactory
implements InterceptorFactory {
    public static final InterceptorFactory INSTANCE = new AsyncFutureInterceptorFactory();

    private AsyncFutureInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final SessionBeanComponent component = (SessionBeanComponent)((Object)context.getContextData().get(Component.class));
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                final InterceptorContext asyncInterceptorContext = context.clone();
                asyncInterceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.ASYNC);
                CancellationFlag flag = new CancellationFlag();
                SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
                final SecurityContext clonedSecurityContext = securityContext instanceof JBossSecurityContext ? (SecurityContext)((JBossSecurityContext)securityContext).clone() : securityContext;
                AsyncInvocationTask task = new AsyncInvocationTask(flag){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Object runInvocation() throws Exception {
                        AsyncFutureInterceptorFactory.setSecurityContextOnAssociation(clonedSecurityContext);
                        try {
                            Object object = asyncInterceptorContext.proceed();
                            return object;
                        }
                        finally {
                            AsyncFutureInterceptorFactory.clearSecurityContextOnAssociation();
                        }
                    }
                };
                asyncInterceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
                ClassLoader oldClassLoader = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(null);
                    component.getAsynchronousExecutor().execute(task);
                }
                finally {
                    SecurityActions.setContextClassLoader(oldClassLoader);
                }
                return task;
            }
        };
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    private static void clearSecurityContextOnAssociation() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }
}

