/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing.clustering;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ClusteredBackingCacheEntryStoreSourceService<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends BackingCacheEntryStoreSourceService<K, V, G, ClusteredBackingCacheEntryStoreSource<K, V, G>> {
    private static final ServiceName BASE_CLIENT_MAPPING_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "remoting", "connector", "client-mappings"});
    private static final ServiceName CLIENT_MAPPING_REGISTRY_SERVICE_NAME = BASE_CLIENT_MAPPING_SERVICE_NAME.append(new String[]{"registry"});
    private static final ServiceName CACHE_FACTORY_CLUSTER_NAME_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "cache", "cluster"});
    private static final ServiceName PASSIVATION_STORE_CLUSTER_NAME_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "store", "cluster"});
    private static final ServiceName CACHE_CONTAINER_CLUSTER_NAME_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "container", "cluster"});
    public static final ServiceName CLIENT_MAPPING_REGISTRY_COLLECTOR_SERVICE_NAME = BASE_CLIENT_MAPPING_SERVICE_NAME.append(new String[]{"collector"});
    private final InjectedValue<RegistryCollector> collector = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();

    public static ServiceName getClientMappingRegistryServiceName(String name) {
        return name != null ? CLIENT_MAPPING_REGISTRY_SERVICE_NAME.append(new String[]{name}) : CLIENT_MAPPING_REGISTRY_SERVICE_NAME;
    }

    public static ServiceName getCacheFactoryClusterNameServiceName(String cacheFactoryName) {
        return cacheFactoryName != null ? CACHE_FACTORY_CLUSTER_NAME_SERVICE_NAME.append(new String[]{cacheFactoryName}) : CACHE_FACTORY_CLUSTER_NAME_SERVICE_NAME;
    }

    public static ServiceName getPassivationStoreClusterNameServiceName(String passivationStoreName) {
        return PASSIVATION_STORE_CLUSTER_NAME_SERVICE_NAME.append(new String[]{passivationStoreName});
    }

    public static ServiceName getCacheContainerClusterNameServiceName(String containerName) {
        return CACHE_CONTAINER_CLUSTER_NAME_SERVICE_NAME.append(new String[]{containerName});
    }

    private static <K extends Serializable, V extends Cacheable<K>, G extends Serializable> ClusteredBackingCacheEntryStoreSource<K, V, G> load() {
        Iterator<ClusteredBackingCacheEntryStoreSource> i$ = ServiceLoader.load(ClusteredBackingCacheEntryStoreSource.class, ClusteredBackingCacheEntryStoreSourceService.class.getClassLoader()).iterator();
        if (i$.hasNext()) {
            ClusteredBackingCacheEntryStoreSource source = i$.next();
            return source;
        }
        throw new ServiceConfigurationError(ClusteredBackingCacheEntryStoreSource.class.getName());
    }

    public ClusteredBackingCacheEntryStoreSourceService(String name) {
        super(name, ClusteredBackingCacheEntryStoreSourceService.<K, V, G>load());
    }

    @Override
    public ServiceBuilder<ClusteredBackingCacheEntryStoreSource<K, V, G>> build(ServiceTarget target) {
        return super.build(target).addDependency(EJBRemoteConnectorService.SERVICE_NAME).addDependency(CLIENT_MAPPING_REGISTRY_COLLECTOR_SERVICE_NAME, RegistryCollector.class, this.collector).addDependency(ClusteredBackingCacheEntryStoreSourceService.getClientMappingRegistryServiceName(((ClusteredBackingCacheEntryStoreSource)this.getValue()).getCacheContainer()), Registry.class, this.registry);
    }

    @Override
    public void start(StartContext context) {
        super.start(context);
        ((RegistryCollector)this.collector.getValue()).add((Registry)this.registry.getValue());
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        ((RegistryCollector)this.collector.getValue()).remove((Registry)this.registry.getValue());
    }
}

