/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.impl.backing.NonPassivatingBackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheLifecycleListener;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCache;
import org.jboss.as.ejb3.cache.spi.impl.RemoveTask;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;

public class NonPassivatingBackingCacheImpl<K extends Serializable, V extends Cacheable<K>>
extends AbstractBackingCache<K, V, NonPassivatingBackingCacheEntry<K, V>>
implements BackingCacheEntryFactory<K, V, NonPassivatingBackingCacheEntry<K, V>> {
    private final StatefulObjectFactory<V> factory;
    private final Map<K, NonPassivatingBackingCacheEntry<K, V>> cache = new ConcurrentHashMap<K, NonPassivatingBackingCacheEntry<K, V>>();
    private final StatefulTimeoutInfo timeout;
    private volatile ScheduledThreadPoolExecutor executor;
    private final ThreadFactory threadFactory;
    private final Map<K, Future<?>> expirationFutures = new ConcurrentHashMap();
    private final ServerEnvironment environment;
    private final IdentifierFactory<K> identifierFactory;

    public NonPassivatingBackingCacheImpl(IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, ThreadFactory threadFactory, StatefulTimeoutInfo timeout, ServerEnvironment environment) {
        this.identifierFactory = identifierFactory;
        this.factory = factory;
        this.timeout = timeout;
        this.threadFactory = threadFactory;
        this.environment = environment;
    }

    public NonPassivatingBackingCacheImpl(IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, ScheduledThreadPoolExecutor executor, StatefulTimeoutInfo timeout, ServerEnvironment environment) {
        this.identifierFactory = identifierFactory;
        this.factory = factory;
        this.timeout = timeout;
        this.executor = executor;
        this.threadFactory = null;
        this.environment = environment;
    }

    @Override
    public K createIdentifier() {
        return (K)((Serializable)this.identifierFactory.createIdentifier());
    }

    @Override
    public Affinity getStrictAffinity() {
        return new NodeAffinity(this.environment.getNodeName());
    }

    @Override
    public Affinity getWeakAffinity(K key) {
        return Affinity.NONE;
    }

    @Override
    public boolean hasAffinity(K key) {
        return true;
    }

    @Override
    public NonPassivatingBackingCacheEntry<K, V> create() {
        BackingCacheEntry entry = this.createEntry((Cacheable)this.factory.createInstance());
        this.cache.put(((NonPassivatingBackingCacheEntry)entry).getUnderlyingItem().getId(), entry);
        return entry;
    }

    @Override
    public NonPassivatingBackingCacheEntry<K, V> createEntry(V item) {
        return new NonPassivatingBackingCacheEntry(item);
    }

    @Override
    public void destroyEntry(NonPassivatingBackingCacheEntry<K, V> entry) {
        this.factory.destroyInstance(entry.getUnderlyingItem());
    }

    @Override
    public NonPassivatingBackingCacheEntry<K, V> get(K key) throws NoSuchEJBException {
        NonPassivatingBackingCacheEntry<K, V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        entry.increaseUsageCount();
        this.scheduleExpiration(key, true);
        return entry;
    }

    @Override
    public NonPassivatingBackingCacheEntry<K, V> peek(K key) throws NoSuchEJBException {
        return this.cache.get(key);
    }

    @Override
    public NonPassivatingBackingCacheEntry<K, V> release(K key) {
        NonPassivatingBackingCacheEntry<K, V> entry = this.cache.get(key);
        if (entry == null) {
            this.log.debug((Object)("SFSB instance with session ID " + key + " not available in cache"));
            return null;
        }
        if (!entry.isInUse()) {
            throw EjbMessages.MESSAGES.cacheEntryNotInUse(key);
        }
        entry.decreaseUsageCount();
        if (!entry.isInUse()) {
            this.scheduleExpiration(key, false);
        }
        return entry;
    }

    @Override
    public void discard(K key) {
        this.cache.remove(key);
    }

    @Override
    public void remove(K key) {
        this.scheduleExpiration(key, true);
        NonPassivatingBackingCacheEntry<K, V> entry = this.cache.remove(key);
        if (entry != null && entry.isInUse()) {
            entry.decreaseUsageCount();
        }
        if (entry != null) {
            this.factory.destroyInstance(entry.getUnderlyingItem());
        }
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public void start() {
        this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STARTING);
        try {
            if (this.threadFactory != null) {
                this.executor = new ScheduledThreadPoolExecutor(1, this.threadFactory);
            }
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STARTED);
        }
        catch (RuntimeException e) {
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.FAILED);
            throw e;
        }
    }

    @Override
    public void stop() {
        this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STOPPING);
        try {
            if (this.threadFactory != null) {
                this.executor.shutdownNow();
            } else {
                for (Future<?> future : this.expirationFutures.values()) {
                    future.cancel(false);
                }
            }
            this.expirationFutures.clear();
            this.cache.clear();
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STOPPED);
        }
        catch (RuntimeException e) {
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.FAILED);
            throw e;
        }
    }

    private void scheduleExpiration(K id, boolean cancel) {
        if (this.timeout != null && this.timeout.getValue() != -1L) {
            Future future;
            Future future2 = future = cancel ? this.expirationFutures.remove(id) : (Future)this.expirationFutures.put(id, this.executor.schedule(new RemoveTask<K>(this, id), this.timeout.getValue(), this.timeout.getTimeUnit()));
            if (future != null && future.cancel(false) && future instanceof Runnable) {
                this.executor.remove((Runnable)((Object)future));
            }
        }
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    @Override
    public int getPassivatedCount() {
        return 0;
    }

    @Override
    public int getTotalSize() {
        return this.cache.size();
    }
}

