/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.FacesLogger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.faces.FacesException;

public final class ByteArrayGuard {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int IV_LENGTH = 8;
    private static final int KEY_LENGTH = 24;
    private static Cipher NULL_CIPHER = new NullCipher();
    private Cipher decryptCipher = NULL_CIPHER;
    private Cipher encryptCipher = NULL_CIPHER;

    public ByteArrayGuard(String string) {
        if (string != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client state saving encryption enabled.");
            }
            byte[] byArray = this.convertPasswordToKey(string.getBytes());
            try {
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
                this.encryptCipher = this.getBlockCipherForEncryption(secretKeyFactory, secureRandom, byArray);
                byte[] byArray2 = this.encryptCipher.getIV();
                this.decryptCipher = this.getBlockCipherForDecryption(secretKeyFactory, secureRandom, byArray, byArray2);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", exception);
                }
                this.encryptCipher = NULL_CIPHER;
                this.decryptCipher = NULL_CIPHER;
            }
        }
    }

    public Cipher getEncryptionCipher() {
        return this.encryptCipher;
    }

    public Cipher getDecryptionCipher() {
        return this.decryptCipher;
    }

    private byte[] convertPasswordToKey(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray2 = messageDigest.digest(byArray);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(byArray2);
            byte[] byArray3 = new byte[24];
            secureRandom.nextBytes(byArray3);
            return byArray3;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private Cipher getBlockCipherForDecryption(SecretKeyFactory secretKeyFactory, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
        try {
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(2, (Key)secretKey, ivParameterSpec, secureRandom);
            return cipher;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private Cipher getBlockCipherForEncryption(SecretKeyFactory secretKeyFactory, SecureRandom secureRandom, byte[] byArray) {
        try {
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            byte[] byArray2 = new byte[8];
            secureRandom.nextBytes(byArray2);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(1, (Key)secretKey, ivParameterSpec, secureRandom);
            return cipher;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }
}

