/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String RENDERKIT = "render-kit";
    private static final String RENDERKIT_ID = "render-kit-id";
    private static final String RENDERKIT_CLASS = "render-kit-class";
    private static final String RENDERER = "renderer";
    private static final String RENDERER_FAMILY = "component-family";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String RENDERER_CLASS = "renderer-class";

    @Override
    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        String string;
        LinkedHashMap<String, Map<Document, List<Node>>> linkedHashMap = new LinkedHashMap<String, Map<Document, List<Node>>>();
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        for (int i = 0; i < documentArray.length; ++i) {
            Map.Entry entry = documentArray[i];
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing render-kit elements for document: ''{0}''", entry.getDocumentURI()));
            }
            string = entry.getDocumentElement().getNamespaceURI();
            NodeList nodeList = entry.getDocumentElement().getElementsByTagNameNS(string, RENDERKIT);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addRenderKits(nodeList, (Document)((Object)entry), linkedHashMap, renderKitFactory);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            string = renderKitFactory.getRenderKit(null, (String)entry.getKey());
            if (string == null) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.CONFIG_RENDERER_REGISTRATION_MISSING_RENDERKIT", entry.getKey()));
            }
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.addRenderers((RenderKit)string, (Document)entry2.getKey(), (List)entry2.getValue());
            }
        }
        this.invokeNext(servletContext, documentArray);
    }

    private void addRenderKits(NodeList nodeList, Document document, Map<String, Map<Document, List<Node>>> map, RenderKitFactory renderKitFactory) {
        String string = document.getDocumentElement().getNamespaceURI();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Map<Document, List<Node>> map2;
            List<Node> list;
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeList2.getLength());
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                list = nodeList2.item(j);
                if (RENDERKIT_ID.equals(list.getLocalName())) {
                    string2 = this.getNodeText((Node)((Object)list));
                    continue;
                }
                if (RENDERKIT_CLASS.equals(list.getLocalName())) {
                    string3 = this.getNodeText((Node)((Object)list));
                    continue;
                }
                if (!RENDERER.equals(list.getLocalName())) continue;
                arrayList.add((Node)((Object)list));
            }
            RenderKit renderKit = renderKitFactory.getRenderKit(null, string2 = string2 == null ? "HTML_BASIC" : string2);
            if (renderKit == null && string3 != null) {
                renderKit = (RenderKit)this.createInstance(string3, RenderKit.class, null, node);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKitFactory.addRenderKit({0}, {1})", string2, string3));
                }
                renderKitFactory.addRenderKit(string2, renderKit);
            }
            if ((map2 = map.get(string2)) != null) {
                list = map2.get(document);
                if (list != null) {
                    list.addAll(arrayList);
                } else {
                    map2.put(document, arrayList);
                }
            } else {
                map2 = new LinkedHashMap<Document, List<Node>>();
                map2.put(document, arrayList);
            }
            map.put(string2, map2);
        }
    }

    private void addRenderers(RenderKit renderKit, Document document, List<Node> list) {
        String string = document.getDocumentElement().getNamespaceURI();
        for (Node node : list) {
            Renderer renderer;
            NodeList nodeList = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (RENDERER_FAMILY.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (RENDERER_TYPE.equals(node2.getLocalName())) {
                    string3 = this.getNodeText(node2);
                    continue;
                }
                if (!RENDERER_CLASS.equals(node2.getLocalName())) continue;
                string4 = this.getNodeText(node2);
            }
            if (string2 == null || string3 == null || string4 == null || (renderer = (Renderer)this.createInstance(string4, Renderer.class, null, node)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addRenderer({0},{1}, {2}) for RenderKit ''{3}''", string2, string3, string4, renderKit.getClass()));
            }
            renderKit.addRenderer(string2, string3, renderer);
        }
    }
}

