/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfResourceProvider
implements ConfigurationResourceProvider {
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(\\S*\\.jar).*");
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";

    @Override
    public Collection<URL> getResources(ServletContext servletContext) {
        Object object;
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.DuplicateJARPattern);
        Pattern pattern = null;
        if (string != null) {
            pattern = Pattern.compile(string);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            object = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
            while (object.hasMoreElements()) {
                URL uRL = object.nextElement();
                String object2 = uRL.toString();
                String string2 = null;
                Matcher matcher = JAR_PATTERN.matcher(object2);
                if (matcher.matches()) {
                    string2 = matcher.group(1);
                }
                if (string2 != null) {
                    if (pattern != null && (matcher = pattern.matcher(string2)).matches()) {
                        string2 = matcher.group(1);
                    }
                    treeMap.put(string2, uRL);
                    continue;
                }
                arrayList.add(0, uRL);
            }
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
        object = new ArrayList(treeMap.size() + arrayList.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            object.add(entry.getValue());
        }
        object.addAll(arrayList);
        return object;
    }
}

