/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.PropertyConfigurable;

public class PropertyAttributeDefinition
extends SimpleAttributeDefinition
implements ConfigurationProperty<String> {
    private final ModelNodeResolver<String> resolver;
    private final String propertyName;

    @Deprecated
    public PropertyAttributeDefinition(String name, String xmlName, String propertyName, ModelNodeResolver<String> resolver, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector corrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AttributeAccess.Flag ... flags) {
        this(name, xmlName, propertyName, resolver, defaultValue, type, allowNull, allowExpression, measurementUnit, corrector, validator, validateNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, (AccessConstraintDefinition[])null, (Boolean)null, flags);
    }

    private PropertyAttributeDefinition(String name, String xmlName, String propertyName, ModelNodeResolver<String> resolver, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector corrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, corrector, validator, validateNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, accessConstraints, nullSignificant, flags);
        this.propertyName = propertyName;
        this.resolver = resolver;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        String value = this.resolvePropertyValue(context, model);
        if (value == null) {
            configuration.removeProperty(this.propertyName);
        } else {
            configuration.setPropertyValueString(this.propertyName, value);
        }
    }

    @Override
    public ModelNodeResolver<String> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        String result = null;
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver == null ? value.asString() : this.resolver.resolveValue(context, value);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = 31 * hash + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyAttributeDefinition)) {
            return false;
        }
        PropertyAttributeDefinition other = (PropertyAttributeDefinition)obj;
        return this.propertyName == null ? other.propertyName == null : this.propertyName.equals(other.propertyName);
    }

    public String toString() {
        return String.format("%s{propertyName=%s,attributeName=%s}", this.getClass().getName(), this.propertyName, this.getName());
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, PropertyAttributeDefinition> {
        private ModelNodeResolver<String> resolver;
        private String propertyName;

        Builder(String name, ModelType type) {
            super(name, type);
        }

        public static Builder of(String name, ModelType type) {
            return new Builder(name, type);
        }

        public static Builder of(String name, ModelType type, boolean allowNull) {
            return (Builder)new Builder(name, type).setAllowNull(allowNull);
        }

        public PropertyAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if (this.propertyName == null) {
                this.propertyName = this.name;
            }
            return new PropertyAttributeDefinition(this.name, this.xmlName, this.propertyName, (ModelNodeResolver)this.resolver, this.defaultValue, this.type, this.allowNull, this.allowExpression, this.measurementUnit, this.corrector, this.validator, this.validateNull, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.accessConstraints, this.nullSignficant, this.flags);
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder setResolver(ModelNodeResolver<String> resolver) {
            this.resolver = resolver;
            return this;
        }
    }
}

