/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.HashMap;
import java.util.Map;

enum Attribute {
    UNKNOWN(null),
    NAME("name"),
    PATH("path"),
    RELATIVE_TO("relative-to"),
    SCAN_ENABLED("scan-enabled"),
    SCAN_INTERVAL("scan-interval"),
    AUTO_DEPLOY_ZIPPED("auto-deploy-zipped"),
    AUTO_DEPLOY_EXPLODED("auto-deploy-exploded"),
    AUTO_DEPLOY_XML("auto-deploy-xml"),
    DEPLOYMENT_TIMEOUT("deployment-timeout");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

