/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.jca.adapters.jdbc.extensions.mysql.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class MySQLReplicationValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static Logger log = Logger.getLogger(MySQLReplicationValidConnectionChecker.class);
    private static final long serialVersionUID = 2658231045989623858L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        Method isValid = null;
        Method ping = null;
        try {
            isValid = c.getClass().getMethod("isValid", new Class[0]);
            SecurityActions.setAccessible(isValid);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (isValid == null) {
            try {
                ping = c.getClass().getMethod("ping", null);
                SecurityActions.setAccessible(ping);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (isValid != null) {
            try {
                isValid.invoke((Object)c, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn((Object)"Unexpected error", (Throwable)e);
                return new SQLException("IsValid failed: " + e.toString());
            }
        }
        if (ping != null) {
            try {
                ping.invoke((Object)c, (Object[])null);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn((Object)"Unexpected error", (Throwable)e);
                return new SQLException("Ping failed: " + e.toString());
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException sQLException = (SQLException)e;
                return sQLException;
            }
            log.warn((Object)"Unexpected error", (Throwable)e);
            SQLException sQLException = new SQLException("SELECT 1 failed: " + e.toString());
            return sQLException;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
        return null;
    }
}

