/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.handler.codec.spdy.DefaultSpdyHeaderBlock;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultSpdySynStreamFrame
extends DefaultSpdyHeaderBlock
implements SpdySynStreamFrame {
    private int streamId;
    private int associatedToStreamId;
    private byte priority;
    private boolean last;
    private boolean unidirectional;

    public DefaultSpdySynStreamFrame(int streamID, int associatedToStreamId, byte priority) {
        this.setStreamId(streamID);
        this.setAssociatedToStreamId(associatedToStreamId);
        this.setPriority(priority);
    }

    @Override
    @Deprecated
    public int getStreamID() {
        return this.getStreamId();
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    @Deprecated
    public void setStreamID(int streamId) {
        this.setStreamId(streamId);
    }

    @Override
    public void setStreamId(int streamId) {
        if (streamId <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamId);
        }
        this.streamId = streamId;
    }

    @Override
    @Deprecated
    public int getAssociatedToStreamID() {
        return this.getAssociatedToStreamId();
    }

    @Override
    public int getAssociatedToStreamId() {
        return this.associatedToStreamId;
    }

    @Override
    @Deprecated
    public void setAssociatedToStreamID(int associatedToStreamId) {
        this.setAssociatedToStreamId(associatedToStreamId);
    }

    @Override
    public void setAssociatedToStreamId(int associatedToStreamId) {
        if (associatedToStreamId < 0) {
            throw new IllegalArgumentException("Associated-To-Stream-ID cannot be negative: " + associatedToStreamId);
        }
        this.associatedToStreamId = associatedToStreamId;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        if (priority < 0 || priority > 7) {
            throw new IllegalArgumentException("Priority must be between 0 and 7 inclusive: " + priority);
        }
        this.priority = priority;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    @Override
    public void setUnidirectional(boolean unidirectional) {
        this.unidirectional = unidirectional;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; unidirectional: ");
        buf.append(this.isUnidirectional());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamId);
        buf.append(StringUtil.NEWLINE);
        if (this.associatedToStreamId != 0) {
            buf.append("--> Associated-To-Stream-ID = ");
            buf.append(this.associatedToStreamId);
            buf.append(StringUtil.NEWLINE);
        }
        buf.append("--> Priority = ");
        buf.append(this.priority);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }
}

