/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FacesServlet
implements Servlet {
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private ServletConfig servletConfig = null;

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletConfig = null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        catch (FacesException facesException) {
            ResourceBundle resourceBundle = LOGGER.getResourceBundle();
            String string = resourceBundle.getString("severe.webapp.facesservlet.init_failed");
            Throwable throwable = facesException.getCause() != null ? facesException.getCause() : facesException;
            LOGGER.log(Level.SEVERE, string, throwable);
            throw new UnavailableException(string);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String string = servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
            if (null == string) {
                string = servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            }
            if (string == null) {
                string = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(string);
        }
        catch (FacesException facesException) {
            Throwable throwable = facesException.getCause();
            if (throwable == null) {
                throw facesException;
            }
            throw new ServletException(facesException.getMessage(), throwable);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        String string = ((HttpServletRequest)servletRequest).getPathInfo();
        if (string != null && ((string = string.toUpperCase()).startsWith("/WEB-INF/") || string.equals("/WEB-INF") || string.startsWith("/META-INF/") || string.equals("/META-INF"))) {
            ((HttpServletResponse)servletResponse).sendError(404);
            return;
        }
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.servletConfig.getServletContext(), servletRequest, servletResponse, this.lifecycle);
        try {
            this.lifecycle.execute(facesContext);
            this.lifecycle.render(facesContext);
        }
        catch (FacesException facesException) {
            Throwable throwable = facesException.getCause();
            if (throwable == null) {
                throw new ServletException(facesException.getMessage(), (Throwable)facesException);
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new ServletException(throwable.getMessage(), throwable);
        }
        finally {
            facesContext.release();
        }
    }
}

