/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class EnumConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Enum";
    public static final String ENUM_ID = "javax.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "javax.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private Class<? extends Enum> targetClass;
    private boolean isTransient = false;

    public EnumConverter() {
    }

    public EnumConverter(Class clazz) {
        this.targetClass = clazz;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, ENUM_NO_CLASS_ID, string, MessageFactory.getLabel(facesContext, uIComponent)));
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        try {
            return Enum.valueOf(this.targetClass, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, ENUM_ID, string, string, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)illegalArgumentException);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, ENUM_NO_CLASS_ID, object, MessageFactory.getLabel(facesContext, uIComponent)));
        }
        if (object == null) {
            return null;
        }
        if (this.targetClass.isInstance(object)) {
            return object.toString();
        }
        throw new ConverterException(MessageFactory.getMessage(facesContext, ENUM_ID, object, object, MessageFactory.getLabel(facesContext, uIComponent)));
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.targetClass = (Class)object;
    }

    public Object saveState(FacesContext facesContext) {
        return this.targetClass;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

