/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryTimeoutException;
import com.google.common.util.concurrent.RateLimiter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.StorageStateListener;

public class StorageSession
implements Host.StateListener {
    private static final int DEFAULT_WARMUP_TIME_IN_MINUTES = 3;
    private static final int MAX_WARMUP_COUNTER = 10;
    private int previousWarmupTime = 3;
    private final Log log = LogFactory.getLog(StorageSession.class);
    private Session wrappedSession;
    private List<StorageStateListener> listeners = new ArrayList<StorageStateListener>();
    private boolean isClusterAvailable = false;
    private double minRequestLimit = Double.parseDouble(System.getProperty("rhq.storage.request.limit.min", "5000"));
    private RateLimiter permits = null;
    private double timeoutDelta = Double.parseDouble(System.getProperty("rhq.storage.request.limit.timeout-delta", "0.2"));
    private long permitsLastChanged = System.currentTimeMillis();
    private long timeoutDampening = Long.parseLong(System.getProperty("rhq.storage.request.timeout-dampening", "30000"));
    private double topologyDelta = Double.parseDouble(System.getProperty("rhq.storage.request.limit.topology-delta", "30000"));

    public StorageSession(Session wrappedSession) {
        this.wrappedSession = wrappedSession;
        this.wrappedSession.getCluster().register((Host.StateListener)this);
        this.permits = this.getRateLimiter(3);
    }

    private RateLimiter getRateLimiter(int warmupTime) {
        return RateLimiter.create((double)this.calculateRequestLimit(), (long)warmupTime, (TimeUnit)TimeUnit.MINUTES);
    }

    public void registerNewSession(Session newWrappedSession) {
        Session oldWrappedSession = this.wrappedSession;
        this.wrappedSession = newWrappedSession;
        this.wrappedSession.getCluster().register((Host.StateListener)this);
        oldWrappedSession.getCluster().unregister((Host.StateListener)this);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        oldWrappedSession.shutdown();
    }

    private double calculateRequestLimit() {
        double rate = 0.0;
        for (Host host : this.wrappedSession.getCluster().getMetadata().getAllHosts()) {
            if (!host.isUp()) continue;
            rate += this.topologyDelta;
        }
        return rate;
    }

    private void setRequestLimit() {
        this.permitsLastChanged = System.currentTimeMillis();
        this.permits.setRate(this.calculateRequestLimit());
    }

    public double getRequestLimit() {
        return new BigDecimal(this.permits.getRate(), new MathContext(2, RoundingMode.HALF_UP)).doubleValue();
    }

    public double getTimeoutDelta() {
        return this.timeoutDelta;
    }

    public void setTimeoutDelta(double timeoutDelta) {
        this.timeoutDelta = timeoutDelta;
    }

    public double getMinRequestLimit() {
        return this.minRequestLimit;
    }

    public void setMinRequestLimit(double minRequestLimit) {
        this.minRequestLimit = minRequestLimit;
    }

    public double getTopologyDelta() {
        return this.topologyDelta;
    }

    public synchronized void setTopologyDelta(double delta) {
        this.topologyDelta = delta;
        this.previousWarmupTime = 3;
        this.setRequestLimit();
    }

    public long getTimeoutDampening() {
        return this.timeoutDampening;
    }

    public void setTimeoutDampening(long timeoutDampening) {
        this.timeoutDampening = timeoutDampening;
    }

    public void addStorageStateListener(StorageStateListener listener) {
        this.listeners.add(listener);
    }

    public ResultSet execute(String query) {
        try {
            this.permits.acquire();
            return this.wrappedSession.execute(query);
        }
        catch (QueryTimeoutException e) {
            this.handleTimeout();
            throw e;
        }
        catch (NoHostAvailableException e) {
            this.handleNoHostAvailable(e);
            throw e;
        }
    }

    public ResultSet execute(Query query) {
        try {
            this.permits.acquire();
            return this.wrappedSession.execute(query);
        }
        catch (QueryTimeoutException e) {
            this.handleTimeout();
            throw e;
        }
        catch (NoHostAvailableException e) {
            this.handleNoHostAvailable(e);
            throw e;
        }
    }

    public StorageResultSetFuture executeAsync(String query) {
        this.permits.acquire();
        ResultSetFuture future = this.wrappedSession.executeAsync(query);
        return new StorageResultSetFuture(future, this);
    }

    public StorageResultSetFuture executeAsync(Query query) {
        this.permits.acquire();
        ResultSetFuture future = this.wrappedSession.executeAsync(query);
        return new StorageResultSetFuture(future, this);
    }

    public PreparedStatement prepare(String query) {
        this.permits.acquire();
        return this.wrappedSession.prepare(query);
    }

    public void shutdown() {
        this.wrappedSession.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        return this.wrappedSession.shutdown(timeout, unit);
    }

    public Cluster getCluster() {
        return this.wrappedSession.getCluster();
    }

    public void onAdd(Host host) {
        this.addOrUp(host, " added");
    }

    public void onUp(Host host) {
        this.addOrUp(host, " is up");
    }

    private void addOrUp(Host host, String msg) {
        this.log.info((Object)(host + msg));
        this.resetRequestThroughput();
        if (!this.isClusterAvailable) {
            this.log.debug((Object)"Storage cluster is up");
        }
        for (StorageStateListener listener : this.listeners) {
            if (!this.isClusterAvailable) {
                listener.onStorageClusterUp();
            }
            listener.onStorageNodeUp(host.getAddress());
        }
        if (!this.isClusterAvailable) {
            this.isClusterAvailable = true;
        }
    }

    public void onDown(Host host) {
        this.resetRequestThroughput();
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeDown(host.getAddress());
        }
    }

    public void onRemove(Host host) {
        this.log.debug((Object)(host + " has been removed."));
        this.resetRequestThroughput();
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeRemoved(host.getAddress());
        }
    }

    void handleNoHostAvailable(NoHostAvailableException e) {
        this.log.warn((Object)("Encountered " + NoHostAvailableException.class.getSimpleName() + " due to following error(s): " + e.getErrors()));
        if (this.isClientTimeout(e)) {
            this.handleTimeout();
        } else {
            this.fireClusterDownEvent(e);
        }
    }

    synchronized void handleTimeout() {
        if (System.currentTimeMillis() - this.permitsLastChanged > this.timeoutDampening) {
            int warmupTime = this.previousWarmupTime;
            if (this.previousWarmupTime < 30) {
                this.previousWarmupTime = warmupTime += 3;
            }
            this.permits = this.getRateLimiter(warmupTime);
            this.log.warn((Object)("Reset warmup period to " + warmupTime + " minutes after a timeout"));
            this.permitsLastChanged = System.currentTimeMillis();
        }
    }

    private synchronized void resetRequestThroughput() {
        double oldRate = this.getRequestLimit();
        double newRate = this.calculateRequestLimit();
        this.setRequestLimit();
        this.log.info((Object)("Changing request throughput from " + oldRate + " request/sec to " + newRate + " requests/sec"));
    }

    private boolean isClientTimeout(NoHostAvailableException e) {
        for (InetAddress address : e.getErrors().keySet()) {
            String error = (String)e.getErrors().get(address);
            if (error == null || !error.contains("Timeout during read") && !error.contains("Timeout while trying to acquire available connection")) continue;
            return true;
        }
        return false;
    }

    private void fireClusterDownEvent(NoHostAvailableException e) {
        this.isClusterAvailable = false;
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageClusterDown(e);
        }
    }
}

