/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;
import org.rhq.server.metrics.domain.Bucket;
import org.rhq.server.metrics.domain.IndexBucket;
import org.rhq.server.metrics.domain.IndexEntry;
import org.rhq.server.metrics.domain.ListPagedResult;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetricMapper;

public class MetricsDAO {
    private final Log log = LogFactory.getLog(MetricsDAO.class);
    private StorageSession storageSession;
    private MetricsConfiguration configuration;
    private PreparedStatement insertRawData;
    private PreparedStatement rawMetricsQuery;
    private PreparedStatement insertOneHourData;
    private PreparedStatement insertSixHourData;
    private PreparedStatement insertTwentyFourHourData;
    private PreparedStatement findLatestRawMetric;
    private PreparedStatement findRawMetrics;
    private PreparedStatement findAggregateMetricsByDateRange;
    private PreparedStatement insertIndexEntry;
    private PreparedStatement findIndexEntries;
    private PreparedStatement findIndexEntriesAfterScheduleId;
    private PreparedStatement deleteIndexEntry;
    private PreparedStatement deleteAggregate;

    public MetricsDAO(StorageSession session, MetricsConfiguration configuration) {
        this.storageSession = session;
        this.configuration = configuration;
        this.initPreparedStatements();
    }

    public void initPreparedStatements() {
        this.log.info((Object)"Initializing prepared statements");
        long startTime = System.currentTimeMillis();
        this.insertRawData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.RAW) + " (schedule_id, time, value) VALUES (?, ?, ?) USING TTL " + this.configuration.getRawTTL());
        this.rawMetricsQuery = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time < ? ORDER BY time");
        this.insertOneHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.AGGREGATE) + "(schedule_id, bucket, time, avg, max, min) " + "VALUES (?, '" + (Object)((Object)Bucket.ONE_HOUR) + "', ?, ?, ?, ?) " + "USING TTL " + this.configuration.getOneHourTTL());
        this.insertSixHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.AGGREGATE) + "(schedule_id, bucket, time, avg, max, min) " + "VALUES (?, '" + (Object)((Object)Bucket.SIX_HOUR) + "', ?, ?, ?, ?) " + "USING TTL " + this.configuration.getSixHourTTL());
        this.insertTwentyFourHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.AGGREGATE) + "(schedule_id, bucket, time, avg, max, min) " + "VALUES (?, '" + (Object)((Object)Bucket.TWENTY_FOUR_HOUR) + "', ?, ?, ?, ?) " + "USING TTL " + this.configuration.getTwentyFourHourTTL());
        this.findLatestRawMetric = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? ORDER BY time DESC LIMIT 1");
        this.findRawMetrics = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time <= ?");
        this.findAggregateMetricsByDateRange = this.storageSession.prepare("SELECT schedule_id, bucket, time, avg, max, min FROM " + (Object)((Object)MetricsTable.AGGREGATE) + " " + "WHERE schedule_id = ? AND bucket = ? AND time >= ? AND time < ?");
        this.insertIndexEntry = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.INDEX) + " (bucket, partition, time, schedule_id) " + "VALUES (?, ?, ?, ?) ");
        this.deleteIndexEntry = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.INDEX) + " " + "WHERE bucket = ? AND partition = ? AND time = ? AND schedule_id = ?");
        this.findIndexEntries = this.storageSession.prepare("SELECT schedule_id FROM " + (Object)((Object)MetricsTable.INDEX) + " " + "WHERE bucket = ? AND partition = ? AND time = ? " + "LIMIT " + this.configuration.getIndexPageSize());
        this.findIndexEntriesAfterScheduleId = this.storageSession.prepare("SELECT schedule_id FROM " + (Object)((Object)MetricsTable.INDEX) + " " + "WHERE bucket = ? AND partition = ? AND time = ? AND schedule_id > ? " + "LIMIT " + this.configuration.getIndexPageSize());
        this.deleteAggregate = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.AGGREGATE) + " " + "WHERE schedule_id = ? AND bucket = ? AND time = ?");
        long endTime = System.currentTimeMillis();
        this.log.info((Object)("Finished initializing prepared statements in " + (endTime - startTime) + " ms"));
    }

    public StorageSession getStorageSession() {
        return this.storageSession;
    }

    public StorageResultSetFuture insertRawData(MeasurementDataNumeric data) {
        BoundStatement statement = this.insertRawData.bind(new Object[]{data.getScheduleId(), new Date(data.getTimestamp()), data.getValue()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture insert1HourData(AggregateNumericMetric metric) {
        BoundStatement statement = this.insertOneHourData.bind(new Object[]{metric.getScheduleId(), new Date(metric.getTimestamp()), metric.getAvg(), metric.getMax(), metric.getMin()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture insert6HourData(AggregateNumericMetric metric) {
        BoundStatement statement = this.insertSixHourData.bind(new Object[]{metric.getScheduleId(), new Date(metric.getTimestamp()), metric.getAvg(), metric.getMax(), metric.getMin()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture insert24HourData(AggregateNumericMetric metric) {
        BoundStatement statement = this.insertTwentyFourHourData.bind(new Object[]{metric.getScheduleId(), new Date(metric.getTimestamp()), metric.getAvg(), metric.getMax(), metric.getMin()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public List<RawNumericMetric> findRawMetrics(int scheduleId, long startTime, long endTime) {
        RawNumericMetricMapper mapper = new RawNumericMetricMapper();
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)boundStatement);
        return mapper.mapAll(resultSet);
    }

    public ResultSet findRawMetricsSync(int scheduleId, long startTime, long endTime) {
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.execute((Query)boundStatement);
    }

    public StorageResultSetFuture findRawMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)boundStatement);
    }

    public RawNumericMetric findLatestRawMetric(int scheduleId) {
        RawNumericMetricMapper mapper = new RawNumericMetricMapper();
        BoundStatement boundStatement = this.findLatestRawMetric.bind(new Object[]{scheduleId});
        ResultSet resultSet = this.storageSession.execute((Query)boundStatement);
        return mapper.mapOne(resultSet);
    }

    public Iterable<RawNumericMetric> findRawMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<RawNumericMetric>(this.findRawMetrics, scheduleIds, startTime, endTime, new RawNumericMetricMapper(), this.storageSession);
    }

    public List<AggregateNumericMetric> findAggregateMetrics(int scheduleId, Bucket bucket, long startTime, long endTime) {
        BoundStatement statement = this.findAggregateMetricsByDateRange.bind(new Object[]{scheduleId, bucket.toString(), new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)statement);
        AggregateNumericMetricMapper mapper = new AggregateNumericMetricMapper();
        return mapper.mapAll(resultSet);
    }

    public StorageResultSetFuture findAggregateMetricsAsync(int scheduleId, Bucket bucket, long startTime, long endTime) {
        BoundStatement statement = this.findAggregateMetricsByDateRange.bind(new Object[]{scheduleId, bucket.toString(), new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findIndexEntries(IndexBucket bucket, int partition, long timestamp) {
        BoundStatement statement = this.findIndexEntries.bind(new Object[]{bucket.toString(), partition, new Date(timestamp)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findIndexEntries(IndexBucket bucket, int partition, long timestamp, int scheduleId) {
        BoundStatement statement = this.findIndexEntriesAfterScheduleId.bind(new Object[]{bucket.toString(), partition, new Date(timestamp), scheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture updateIndex(IndexBucket bucket, long timestamp, int scheduleId) {
        BoundStatement statement = this.insertIndexEntry.bind(new Object[]{bucket.toString(), scheduleId % this.configuration.getIndexPartitions(), new Date(timestamp), scheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture deleteIndexEntry(IndexEntry indexEntry) {
        BoundStatement statement = this.deleteIndexEntry.bind(new Object[]{indexEntry.getBucket().toString(), indexEntry.getPartition(), new Date(indexEntry.getTimestamp()), indexEntry.getScheduleId()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public void deleteAggregate(AggregateNumericMetric metric) {
        BoundStatement statement = this.deleteAggregate.bind(new Object[]{metric.getScheduleId(), metric.getBucket().toString(), new Date(metric.getTimestamp())});
        this.storageSession.execute((Query)statement);
    }
}

