/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.Bucket;

public class MetricsBaselineCalculator {
    private final Log log = LogFactory.getLog(MetricsBaselineCalculator.class);
    private MetricsDAO metricsDAO;

    public MetricsBaselineCalculator(MetricsDAO metricsDAO) {
        this.metricsDAO = metricsDAO;
    }

    public Map<Integer, MeasurementBaseline> calculateBaselines(Set<Integer> scheduleIds, long startTime, long endTime) {
        HashMap<Integer, MeasurementBaseline> calculatedBaselines = new HashMap<Integer, MeasurementBaseline>();
        for (Integer scheduleId : scheduleIds) {
            MeasurementBaseline measurementBaseline = this.calculateBaseline(scheduleId, startTime, endTime);
            if (measurementBaseline == null) continue;
            calculatedBaselines.put(scheduleId, measurementBaseline);
        }
        return calculatedBaselines;
    }

    private MeasurementBaseline calculateBaseline(Integer schedule, long startTime, long endTime) {
        List<AggregateNumericMetric> metrics = this.metricsDAO.findAggregateMetrics(schedule, Bucket.ONE_HOUR, startTime, endTime);
        if (metrics.isEmpty()) {
            return null;
        }
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        Double max = metrics.get(0).getMax();
        Double min = metrics.get(0).getMin();
        for (AggregateNumericMetric metric : metrics) {
            mean.add(metric.getAvg());
            if (metric.getMax() > max) {
                max = metric.getMax();
            }
            if (!(metric.getMin() < min)) continue;
            min = metric.getMin();
        }
        MeasurementBaseline baseline = new MeasurementBaseline();
        baseline.setMax(max);
        baseline.setMin(min);
        baseline.setMean(Double.valueOf(mean.getArithmeticMean()));
        baseline.setScheduleId(schedule.intValue());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Calculated baseline: " + baseline.toString()));
        }
        return baseline;
    }
}

