/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.rhq.server.metrics.MetricsConfiguration;

public class DateTimeService {
    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();
    protected MetricsConfiguration configuration;

    public void setConfiguration(MetricsConfiguration configuration) {
        this.configuration = configuration;
    }

    public DateTime now() {
        return new DateTime(this.nowInMillis());
    }

    public long nowInMillis() {
        return System.currentTimeMillis();
    }

    public DateTime getTimeSlice(long timestamp, Duration duration) {
        return this.getTimeSlice(new DateTime(timestamp), duration);
    }

    public DateTime getTimeSlice(DateTime dt, Duration duration) {
        Period p = duration.toPeriod();
        if (p.getYears() != 0) {
            return dt.yearOfEra().roundFloorCopy().minusYears(dt.getYearOfEra() % p.getYears());
        }
        if (p.getMonths() != 0) {
            return dt.monthOfYear().roundFloorCopy().minusMonths((dt.getMonthOfYear() - 1) % p.getMonths());
        }
        if (p.getWeeks() != 0) {
            return dt.weekOfWeekyear().roundFloorCopy().minusWeeks((dt.getWeekOfWeekyear() - 1) % p.getWeeks());
        }
        if (p.getDays() != 0) {
            return dt.dayOfMonth().roundFloorCopy().minusDays((dt.getDayOfMonth() - 1) % p.getDays());
        }
        if (p.getHours() != 0) {
            return dt.hourOfDay().roundFloorCopy().minusHours(dt.getHourOfDay() % p.getHours());
        }
        if (p.getMinutes() != 0) {
            return dt.minuteOfHour().roundFloorCopy().minusMinutes(dt.getMinuteOfHour() % p.getMinutes());
        }
        if (p.getSeconds() != 0) {
            return dt.secondOfMinute().roundFloorCopy().minusSeconds(dt.getSecondOfMinute() % p.getSeconds());
        }
        return dt.millisOfSecond().roundCeilingCopy().minusMillis(dt.getMillisOfSecond() % p.getMillis());
    }

    public boolean isInRawDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)this.now().minus(this.configuration.getRawRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn1HourDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)this.now().minus(this.configuration.getOneHourRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn6HourDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)this.now().minus(this.configuration.getSixHourRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn24HourDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)this.now().minus(this.configuration.getTwentyFourHourRetention()), (Object)dateTime) < 0;
    }

    public DateTime currentHour() {
        return this.getTimeSlice(this.now(), this.configuration.getRawTimeSliceDuration());
    }

    public DateTime current6HourTimeSlice() {
        return this.get6HourTimeSlice(this.currentHour());
    }

    public DateTime current24HourTimeSlice() {
        return this.get24HourTimeSlice(this.currentHour());
    }

    public DateTime get24HourTimeSlice(DateTime time) {
        return this.getTimeSlice(time, this.configuration.getSixHourTimeSliceDuration());
    }

    public DateTime get24HourTimeSliceEnd(DateTime time) {
        return this.get24HourTimeSlice(time).plus((ReadableDuration)this.configuration.getSixHourTimeSliceDuration());
    }

    public DateTime get24HourTimeSlice(long timestamp) {
        return this.get24HourTimeSlice(new DateTime(timestamp));
    }

    public DateTime get6HourTimeSlice(DateTime time) {
        return this.getTimeSlice(time, this.configuration.getOneHourTimeSliceDuration());
    }

    public DateTime get6HourTimeSlice(long timestamp) {
        return this.get6HourTimeSlice(new DateTime(timestamp));
    }

    public DateTime get6HourTimeSliceEnd(DateTime time) {
        return this.get6HourTimeSlice(time).plus((ReadableDuration)this.configuration.getOneHourTimeSliceDuration());
    }

    public DateTime get1HourTimeSlice(DateTime time) {
        return this.getTimeSlice(time, this.configuration.getRawTimeSliceDuration());
    }

    public boolean is6HourTimeSliceFinished(DateTime time) {
        return this.hasTimeSliceEnded(this.get6HourTimeSlice(time), this.configuration.getOneHourTimeSliceDuration());
    }

    public boolean is6HourTimeSliceFinished(long timestamp) {
        return this.is6HourTimeSliceFinished(new DateTime(timestamp));
    }

    public boolean is24HourTimeSliceFinished(DateTime time) {
        return this.hasTimeSliceEnded(this.get24HourTimeSlice(time), this.configuration.getSixHourTimeSliceDuration());
    }

    public boolean is24HourTimeSliceFinished(long timestamp) {
        return this.is24HourTimeSliceFinished(new DateTime(timestamp));
    }

    private boolean hasTimeSliceEnded(DateTime startTime, Duration duration) {
        DateTime endTime = startTime.plus((ReadableDuration)duration);
        return DateTimeComparator.getInstance().compare((Object)this.currentHour(), (Object)endTime) >= 0;
    }

    public DateTime hour0() {
        DateTime rightNow = this.now();
        return rightNow.hourOfDay().roundFloorCopy().minusHours(rightNow.hourOfDay().roundFloorCopy().hourOfDay().get());
    }

    static {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
    }
}

