/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rhq.enterprise.server.plugins.yum.RepoReader;

public class Repodata {
    private final RepoReader reader;
    private SAXBuilder builder = new SAXBuilder();
    private Map<Meta, String> locations = new HashMap<Meta, String>();
    private Map<Meta, Element> documents = new HashMap<Meta, Element>();
    public static final Namespace yumns = Namespace.getNamespace((String)"http://linux.duke.edu/metadata/common");
    public static final Namespace repons = Namespace.getNamespace((String)"http://linux.duke.edu/metadata/repo");
    public static final Namespace rpmns = Namespace.getNamespace((String)"rpm", (String)"http://linux.duke.edu/metadata/rpm");

    public Repodata(RepoReader reader) {
        this.reader = reader;
    }

    public void refresh() throws Exception {
        this.clear();
        Element repomd = this.getRepomd();
        for (Meta t : Meta.values()) {
            this.locations.put(t, this.getLocation(repomd, t));
        }
    }

    public void clear() {
        this.locations.clear();
        this.documents.clear();
    }

    public RepoReader getReader() {
        return this.reader;
    }

    public Element getRepomd() throws Exception {
        InputStream istr = this.reader.openStream("repodata/repomd.xml");
        return this.builder.build(istr).getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getMetadata(Meta type) throws Exception {
        Element node = this.documents.get((Object)type);
        InputStream istr = null;
        try {
            if (node == null) {
                String href = this.locations.get((Object)type);
                istr = this.reader.openStream(href);
                node = this.builder.build(istr).getRootElement();
                this.documents.put(type, node);
            }
        }
        finally {
            if (istr != null) {
                istr.close();
            }
        }
        return node;
    }

    public String toString(Meta type) throws Exception {
        return Repodata.toString(this.getMetadata(type));
    }

    private String getLocation(Element repomd, Meta type) {
        String href = "";
        for (Element e : repomd.getChildren()) {
            String typeAttribute = e.getAttributeValue("type");
            if (typeAttribute == null || !typeAttribute.equals(type.name())) continue;
            Element location = e.getChild("location", repons);
            href = location.getAttributeValue("href");
            break;
        }
        return href;
    }

    public static String toString(Element e) {
        Format format = Format.getPrettyFormat();
        XMLOutputter p = new XMLOutputter(format);
        return p.outputString(e);
    }

    static enum Meta {
        primary,
        filelists,
        other;

    }
}

