/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.concurrency;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.concurrency.LockSetFactoryImpl;
import org.jacorb.concurrency.Request;
import org.jacorb.concurrency.TransactionCoordinator;
import org.jacorb.concurrency.TransactionLocks;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosConcurrencyControl.LockCoordinator;
import org.omg.CosConcurrencyControl.LockNotHeld;
import org.omg.CosConcurrencyControl.TransactionalLockSet;
import org.omg.CosConcurrencyControl.TransactionalLockSetPOA;
import org.omg.CosConcurrencyControl.lock_mode;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Status;

class TransactionalLockSetImpl
extends TransactionalLockSetPOA {
    private Hashtable locks = new Hashtable();
    private Vector queue = new Vector();
    private Vector related = new Vector();
    private LockSetFactoryImpl factory;
    private boolean is_active = true;

    TransactionalLockSetImpl(LockSetFactoryImpl factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Coordinator current, lock_mode mode) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            TransactionCoordinator tc = this.factory.get_transaction_coordinator(current);
            Request rqst = null;
            TransactionCoordinator transactionCoordinator = tc;
            synchronized (transactionCoordinator) {
                this.check_status(tc);
                if (this.attempt_lock(tc, mode)) {
                    return;
                }
                rqst = new Request();
                rqst.state = 1;
                rqst.current = tc;
                rqst.to_do = 1;
                rqst.set_mode = mode;
                rqst.reset_mode = null;
                this.queue.addElement(rqst);
                tc.set_lock_coordinator(this);
            }
            while (rqst.state == 1) {
                try {
                    this.queue.wait();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    throw new INTERNAL();
                }
            }
            switch (rqst.state) {
                case 3: 
                case 5: {
                    throw new INVALID_TRANSACTION();
                }
                case 4: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean try_lock(Coordinator current, lock_mode mode) {
        Vector vector = this.queue;
        synchronized (vector) {
            TransactionCoordinator tc;
            this.check_active();
            TransactionCoordinator transactionCoordinator = tc = this.factory.get_transaction_coordinator(current);
            synchronized (transactionCoordinator) {
                this.check_status(tc);
                return this.attempt_lock(tc, mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Coordinator current, lock_mode mode) throws LockNotHeld {
        Vector vector = this.queue;
        synchronized (vector) {
            TransactionCoordinator tc;
            this.check_active();
            TransactionCoordinator transactionCoordinator = tc = this.factory.get_transaction_coordinator(current);
            synchronized (transactionCoordinator) {
                this.check_status(tc);
                TransactionLocks current_locks = (TransactionLocks)this.locks.get((Object)tc);
                if (current_locks == null) {
                    throw new LockNotHeld();
                }
                current_locks.unlock(mode);
            }
            if (this.attempt_lock_from_queue()) {
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change_mode(Coordinator current, lock_mode held_mode, lock_mode new_mode) throws LockNotHeld {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            TransactionCoordinator tc = this.factory.get_transaction_coordinator(current);
            Request rqst = null;
            TransactionCoordinator transactionCoordinator = tc;
            synchronized (transactionCoordinator) {
                this.check_status(tc);
                if (this.attempt_change(tc, new_mode, held_mode)) {
                    return;
                }
                rqst = new Request();
                rqst.state = 1;
                rqst.current = tc;
                rqst.to_do = 3;
                rqst.set_mode = new_mode;
                rqst.reset_mode = held_mode;
                this.queue.addElement(rqst);
                tc.get_lock_coordinator(this);
            }
            while (rqst.state == 1) {
                try {
                    this.queue.wait();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    throw new INTERNAL();
                }
            }
            switch (rqst.state) {
                case 3: 
                case 5: {
                    throw new INVALID_TRANSACTION();
                }
                case 4: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case 6: {
                    throw new LockNotHeld();
                }
            }
            if (this.attempt_lock_from_queue()) {
                this.queue.notifyAll();
            }
        }
    }

    public LockCoordinator get_coordinator(Coordinator which) {
        TransactionCoordinator tc = this.factory.get_transaction_coordinator(which);
        return tc.get_lock_coordinator(this);
    }

    synchronized void add_related(TransactionalLockSet which) {
        this.related.addElement(which);
    }

    synchronized boolean attempt_lock(TransactionCoordinator tc, lock_mode mode) {
        Enumeration enumeration = this.locks.elements();
        TransactionLocks current_transaction_locks = null;
        while (enumeration.hasMoreElements()) {
            TransactionLocks lock = (TransactionLocks)enumeration.nextElement();
            if (lock.current == tc) {
                current_transaction_locks = lock;
                continue;
            }
            if (lock.no_conflict(mode)) continue;
            return false;
        }
        if (current_transaction_locks == null) {
            current_transaction_locks = new TransactionLocks(tc);
            tc.get_lock_coordinator(this);
            this.locks.put(tc, current_transaction_locks);
        }
        current_transaction_locks.lock(mode);
        return true;
    }

    private void check_status(TransactionCoordinator tc) {
        Status status = tc.get_state();
        if (status.equals(Status.StatusActive)) {
            return;
        }
        if (status.equals(Status.StatusPrepared) || status.equals(Status.StatusCommitted) || status.equals(Status.StatusUnknown) || status.equals(Status.StatusNoTransaction) || status.equals(Status.StatusPreparing) || status.equals(Status.StatusCommitting)) {
            throw new INVALID_TRANSACTION();
        }
        if (status.equals(Status.StatusRollingBack) || status.equals(Status.StatusMarkedRollback) || status.equals(Status.StatusRolledBack)) {
            throw new TRANSACTION_ROLLEDBACK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean attempt_lock_from_queue() {
        boolean do_recursive = false;
        Vector<Request> executed = new Vector<Request>();
        Enumeration enumeration = this.queue.elements();
        block12: while (enumeration.hasMoreElements()) {
            Request r = (Request)enumeration.nextElement();
            TransactionCoordinator transactionCoordinator = r.current;
            synchronized (transactionCoordinator) {
                try {
                    this.check_status(r.current);
                }
                catch (INVALID_TRANSACTION e) {
                    r.state = 5;
                    executed.addElement(r);
                    continue;
                }
                catch (TRANSACTION_ROLLEDBACK e) {
                    r.state = 4;
                    executed.addElement(r);
                    continue;
                }
                switch (r.to_do) {
                    case 1: {
                        if (!this.attempt_lock(r.current, r.set_mode)) {
                            continue block12;
                        }
                        r.state = 2;
                        break;
                    }
                    case 3: {
                        try {
                            if (!this.attempt_change(r.current, r.set_mode, r.reset_mode)) {
                                continue block12;
                            }
                            r.state = 2;
                            do_recursive = true;
                            break;
                        }
                        catch (LockNotHeld e) {
                            r.state = 6;
                        }
                    }
                }
                executed.addElement(r);
            }
        }
        enumeration = executed.elements();
        while (enumeration.hasMoreElements()) {
            this.queue.removeElement(enumeration.nextElement());
        }
        if (do_recursive) {
            this.attempt_lock_from_queue();
        }
        return executed.size() > 0;
    }

    private synchronized boolean attempt_change(TransactionCoordinator tc, lock_mode set_mode, lock_mode reset_mode) throws LockNotHeld {
        TransactionLocks current_locks = (TransactionLocks)this.locks.get((Object)tc);
        if (current_locks == null || !current_locks.is_held(reset_mode)) {
            throw new LockNotHeld();
        }
        if (this.attempt_lock(tc, set_mode)) {
            current_locks.unlock(reset_mode);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void transaction_finished(TransactionCoordinator tc) {
        Enumeration enumeration;
        Vector<Request> executed = new Vector<Request>();
        boolean do_notify = false;
        Vector vector = this.queue;
        synchronized (vector) {
            enumeration = this.queue.elements();
            while (enumeration.hasMoreElements()) {
                Request r = (Request)enumeration.nextElement();
                if (r.current != tc) continue;
                r.state = 4;
                executed.addElement(r);
            }
            if (executed.size() > 0) {
                enumeration = executed.elements();
                while (enumeration.hasMoreElements()) {
                    this.queue.removeElement(enumeration.nextElement());
                }
                do_notify = true;
            }
            if (this.locks.remove((Object)tc) != null) {
                boolean bl = do_notify = this.attempt_lock_from_queue() ? true : do_notify;
            }
            if (do_notify) {
                this.queue.notifyAll();
            }
        }
        if (this.related.size() > 0) {
            enumeration = this.related.elements();
            while (enumeration.hasMoreElements()) {
                TransactionalLockSet ls = (TransactionalLockSet)enumeration.nextElement();
                ls.get_coordinator(tc.get_coordinator()).drop_locks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        System.out.println("\n=============================================================================");
        System.out.println(" LOCKS" + this.locks.size());
        System.out.println("-----------------------------------------------------------------------------");
        Vector vector = this.queue;
        synchronized (vector) {
            Object r;
            Enumeration<Object> enumeration = this.locks.elements();
            while (enumeration.hasMoreElements()) {
                r = (TransactionLocks)enumeration.nextElement();
                System.out.println(((TransactionLocks)r).toString());
            }
            System.out.println("\n-----------------------------------------------------------------------------");
            System.out.println(" QUEUE" + this.queue.size());
            System.out.println("-----------------------------------------------------------------------------");
            enumeration = this.queue.elements();
            while (enumeration.hasMoreElements()) {
                r = (Request)enumeration.nextElement();
                System.out.println(((Request)r).toString());
            }
        }
        System.out.println("=============================================================================\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            this.is_active = false;
            if (this.locks.size() > 0) {
                Enumeration enumeration = this.locks.elements();
                while (enumeration.hasMoreElements()) {
                    TransactionLocks ls = (TransactionLocks)enumeration.nextElement();
                    if (!ls.any_locks()) continue;
                    throw new RuntimeException("LockExists");
                }
            }
            this.factory.remove_me(this);
        }
    }

    private void check_active() {
        if (!this.is_active) {
            throw new OBJECT_NOT_EXIST();
        }
    }
}

