/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.extensions.compactnotation;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.extensions.compactnotation.CompactData;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class CompactConstructor
extends Constructor {
    private static final Pattern FIRST_PATTERN = Pattern.compile("(\\p{Alpha}.*)(\\s*)\\((.*?)\\)");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\s*(\\p{Alpha}\\w*)\\s*=(.+)");

    @Override
    protected Object constructScalar(ScalarNode node) {
        CompactData data = this.getCompactData(node.getValue());
        if (data != null) {
            return this.constructCompactFormat(node, data);
        }
        return super.constructScalar(node);
    }

    protected Object constructCompactFormat(ScalarNode node, CompactData data) {
        try {
            Object obj = this.createInstance(node, data);
            HashMap<String, Object> properties = new HashMap<String, Object>(data.getProperties());
            this.setProperties(obj, properties);
            return obj;
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected Object createInstance(ScalarNode node, CompactData data) throws Exception {
        Class<?> clazz = this.getClassForName(data.getPrefix());
        Class[] args = new Class[data.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = String.class;
        }
        java.lang.reflect.Constructor<?> c = clazz.getDeclaredConstructor(args);
        c.setAccessible(true);
        return c.newInstance(data.getArguments().toArray());
    }

    protected void setProperties(Object bean, Map<String, Object> data) throws Exception {
        if (data == null) {
            throw new NullPointerException("Data for Compact Object Notation cannot be null.");
        }
        for (String key : data.keySet()) {
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), key);
            try {
                property.set(bean, data.get(key));
            }
            catch (IllegalArgumentException e) {
                throw new YAMLException("Cannot set property='" + key + "' with value='" + data.get(key) + "' (" + data.get(key).getClass() + ") in " + bean);
            }
        }
    }

    public CompactData getCompactData(String scalar) {
        if (!scalar.endsWith(")")) {
            return null;
        }
        if (scalar.indexOf(40) < 0) {
            return null;
        }
        Matcher m = FIRST_PATTERN.matcher(scalar);
        if (m.matches()) {
            String tag = m.group(1).trim();
            String content = m.group(3);
            CompactData data = new CompactData(tag);
            if (content.length() == 0) {
                return data;
            }
            String[] names = content.split("\\s*,\\s*");
            for (int i = 0; i < names.length; ++i) {
                String section = names[i];
                if (section.indexOf(61) < 0) {
                    data.getArguments().add(section);
                    continue;
                }
                Matcher sm = PROPERTY_NAME_PATTERN.matcher(section);
                if (sm.matches()) {
                    String name = sm.group(1);
                    String value = sm.group(2).trim();
                    data.getProperties().put(name, value);
                    continue;
                }
                return null;
            }
            return data;
        }
        return null;
    }

    @Override
    protected Construct getConstructor(Node node) {
        ScalarNode scalar;
        CompactData data;
        NodeTuple tuple;
        Node key;
        MappingNode mnode;
        List<NodeTuple> list;
        if (node instanceof MappingNode && (list = (mnode = (MappingNode)node).getValue()).size() == 1 && (key = (tuple = list.get(0)).getKeyNode()) instanceof ScalarNode && (data = this.getCompactData((scalar = (ScalarNode)key).getValue())) != null) {
            return new ConstructCompactObject();
        }
        return super.getConstructor(node);
    }

    protected void applySequence(Object bean, List<?> value) {
        try {
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), this.getSequencePropertyName(bean.getClass()));
            property.set(bean, value);
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected String getSequencePropertyName(Class<?> bean) throws IntrospectionException {
        Set<Property> properties = this.getPropertyUtils().getProperties(bean);
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (List.class.isAssignableFrom(property.getType())) continue;
            iterator.remove();
        }
        if (properties.size() == 0) {
            throw new YAMLException("No list property found in " + bean);
        }
        if (properties.size() > 1) {
            throw new YAMLException("Many list properties found in " + bean + "; Please override getSequencePropertyName() to specify which property to use.");
        }
        return properties.iterator().next().getName();
    }

    public class ConstructCompactObject
    extends AbstractConstruct {
        @Override
        public Object construct(Node node) {
            Map map = CompactConstructor.this.constructMapping((MappingNode)node);
            Map.Entry entry = map.entrySet().iterator().next();
            Object result = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map properties = (Map)value;
                try {
                    CompactConstructor.this.setProperties(result, properties);
                }
                catch (Exception e) {
                    throw new YAMLException(e);
                }
            } else {
                CompactConstructor.this.applySequence(result, (List)value);
            }
            return result;
        }
    }
}

