/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import mazz.i18n.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandResponse;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.command.server.AuthenticationException;
import org.rhq.enterprise.communications.command.server.CommandAuthenticator;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.command.server.CommandProcessorMetrics;
import org.rhq.enterprise.communications.command.server.CommandServiceDirectoryMBean;
import org.rhq.enterprise.communications.command.server.CommandServiceMBean;
import org.rhq.enterprise.communications.command.server.IncomingCommandTrace;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.NotPermittedException;
import org.rhq.enterprise.communications.util.NotProcessedException;

public class CommandProcessor
implements StreamInvocationHandler {
    private static final Logger LOG = CommI18NFactory.getLogger(CommandProcessor.class);
    private MBeanServer m_mBeanServer = null;
    private CommandServiceDirectoryMBean m_directoryService = null;
    private CommandAuthenticator m_authenticator = null;
    private final List<CommandListener> m_commandListeners = new CopyOnWriteArrayList<CommandListener>();
    private final CommandProcessorMetrics m_metrics = new CommandProcessorMetrics();

    public void setMBeanServer(MBeanServer mbs) {
        this.m_mBeanServer = mbs;
    }

    public void setInvoker(ServerInvoker invoker) {
    }

    public void setCommandAuthenticator(CommandAuthenticator authenticator) {
        this.m_authenticator = authenticator;
        LOG.debug("CommandProcessor.authenticator-set", new Object[]{authenticator});
    }

    public void addCommandListener(CommandListener listener) {
        this.m_commandListeners.add(listener);
    }

    public void removeCommandListener(CommandListener listener) {
        this.m_commandListeners.remove(listener);
    }

    public CommandProcessorMetrics getCommandProcessorMetrics() {
        return this.m_metrics;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        return this.handleIncomingInvocationRequest(null, invocation);
    }

    public Object handleStream(InputStream in, InvocationRequest invocation) throws Throwable {
        return this.handleIncomingInvocationRequest(in, invocation);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object handleIncomingInvocationRequest(InputStream in, InvocationRequest invocation) {
        block24: {
            block23: {
                cmd = null;
                ret_response /* !! */  = null;
                elapsed = 0L;
                subsystem = invocation.getSubsystem();
                cmd = (Command)invocation.getParameter();
                IncomingCommandTrace.start(cmd);
                if (cmd == null) ** GOTO lbl46
                this.notifyListenersOfReceivedCommand(cmd);
                if (this.m_authenticator == null || this.m_authenticator.isAuthenticated(cmd)) break block23;
                if (cmd.getCommandType() == null || !cmd.getCommandType().getName().equals(IdentifyCommand.COMMAND_TYPE.getName())) {
                    CommandProcessor.LOG.warn("CommandProcessor.failed-authentication", new Object[]{cmd});
                    ++this.m_metrics.numberFailedCommands;
                }
                err = CommandProcessor.LOG.getMsgString("CommandProcessor.failed-authentication", new Object[]{cmd});
                ret_response /* !! */  = new GenericCommandResponse(null, false, null, new AuthenticationException(err));
                this.notifyListenersOfProcessedCommand(cmd, ret_response /* !! */ );
                var9_13 = ret_response /* !! */ ;
                IncomingCommandTrace.finish(cmd, ret_response /* !! */ );
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                return var9_13;
            }
            try {
                cmdType = cmd.getCommandType();
                entry = null;
                cmdServiceName = null;
                entry = this.getCommandServiceDirectory().getCommandTypeProvider(subsystem, cmdType);
                if (entry != null) {
                    cmdServiceName = entry.getCommandServiceName();
                }
                if (cmdServiceName != null) {
                    executor = MBeanServerInvocationHandler.newProxyInstance(this.m_mBeanServer, cmdServiceName, CommandServiceMBean.class, false);
                    CommandProcessor.LOG.debug("CommandProcessor.executing", new Object[]{cmd});
                    start = System.currentTimeMillis();
                    ret_response /* !! */  = executor.execute(cmd, in, null);
                    elapsed = System.currentTimeMillis() - start;
                    CommandProcessor.LOG.debug("CommandProcessor.executed", new Object[]{ret_response /* !! */ });
                    break block24;
                }
                throw new InstanceNotFoundException(CommandProcessor.LOG.getMsgString("CommandProcessor.unsupported-command-type", new Object[]{subsystem, cmdType}));
lbl46:
                // 1 sources

                CommandProcessor.LOG.warn("CommandProcessor.no-command", new Object[0]);
                ret_response /* !! */  = new GenericCommandResponse(null, false, null, new Exception(CommandProcessor.LOG.getMsgString("CommandProcessor.no-command", new Object[0])));
            }
            catch (Throwable t) {
                try {
                    ret_response /* !! */  = new GenericCommandResponse(cmd, false, null, t);
                }
                catch (Throwable var14_19) {
                    IncomingCommandTrace.finish(cmd, ret_response /* !! */ );
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw var14_19;
                }
                IncomingCommandTrace.finish(cmd, ret_response /* !! */ );
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable t) {}
                } else {
                    ** GOTO lbl76
                }
            }
        }
        IncomingCommandTrace.finish(cmd, ret_response /* !! */ );
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
        try {
            if (ret_response /* !! */  == null) {
                ret_response /* !! */  = new GenericCommandResponse(cmd, false, null, new IllegalStateException("results are null"));
            }
            this.updateMetrics(cmd, ret_response /* !! */ , elapsed);
            this.notifyListenersOfProcessedCommand(cmd, ret_response /* !! */ );
        }
        catch (Throwable t) {
            CommandProcessor.LOG.warn(t, "CommandProcessor.post-processing-failure", new Object[]{cmd});
        }
        return ret_response /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetrics(Command cmd, CommandResponse response, long elapsed) {
        boolean success = response.isSuccessful();
        CommandProcessorMetrics.UnsuccessfulReason unsuccessfulReason = null;
        this.m_metrics.writeLock();
        try {
            if (success) {
                long num = ++this.m_metrics.numberSuccessfulCommands;
                long currentAvg = this.m_metrics.averageExecutionTime;
                this.m_metrics.averageExecutionTime = currentAvg = ((num - 1L) * currentAvg + elapsed) / num;
            } else if (response.getException() instanceof NotPermittedException) {
                ++this.m_metrics.numberDroppedCommands;
                unsuccessfulReason = CommandProcessorMetrics.UnsuccessfulReason.DROPPED;
            } else if (response.getException() instanceof NotProcessedException) {
                ++this.m_metrics.numberNotProcessedCommands;
                unsuccessfulReason = CommandProcessorMetrics.UnsuccessfulReason.NOT_PROCESSED;
            } else {
                ++this.m_metrics.numberFailedCommands;
                unsuccessfulReason = CommandProcessorMetrics.UnsuccessfulReason.FAILED;
            }
            if (cmd != null) {
                CommandType cmdType = cmd.getCommandType();
                this.m_metrics.addCallTimeData(cmdType.getName(), elapsed, unsuccessfulReason);
                if (cmd instanceof RemotePojoInvocationCommand) {
                    RemotePojoInvocationCommand pojoCmd = (RemotePojoInvocationCommand)cmd;
                    String ifaceName = pojoCmd.getTargetInterfaceName();
                    ifaceName = ifaceName.substring(ifaceName.lastIndexOf(46) + 1);
                    String methodName = pojoCmd.getNameBasedInvocation().getMethodName();
                    this.m_metrics.addCallTimeData(ifaceName + '.' + methodName, elapsed, unsuccessfulReason);
                }
            }
        }
        finally {
            this.m_metrics.writeUnlock();
        }
    }

    private void notifyListenersOfReceivedCommand(Command command) {
        for (CommandListener listener : this.m_commandListeners) {
            try {
                listener.receivedCommand(command);
            }
            catch (NotPermittedException npe) {
                throw npe;
            }
            catch (NotProcessedException npe) {
                throw npe;
            }
            catch (Throwable t) {
                LOG.warn(t, "CommandProcessor.listener-error.received", new Object[]{t});
            }
        }
    }

    private void notifyListenersOfProcessedCommand(Command command, CommandResponse response) {
        for (CommandListener listener : this.m_commandListeners) {
            try {
                listener.processedCommand(command, response);
            }
            catch (Throwable t) {
                LOG.warn(t, "CommandProcessor.listener-error.processed", new Object[]{t});
            }
        }
    }

    private CommandServiceDirectoryMBean getCommandServiceDirectory() throws Exception {
        if (this.m_directoryService == null) {
            ObjectName query = new ObjectName("*:type=directory");
            Set<ObjectName> names = this.m_mBeanServer.queryNames(query, null);
            if (names != null) {
                ObjectName directoryName = names.iterator().next();
                this.m_directoryService = MBeanServerInvocationHandler.newProxyInstance(this.m_mBeanServer, directoryName, CommandServiceDirectoryMBean.class, false);
            } else {
                throw new InstanceNotFoundException(LOG.getMsgString("CommandProcessor.no-directory", new Object[]{query}));
            }
        }
        return this.m_directoryService;
    }
}

