/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class BlueprintBeanLocator
implements ConfiguredBeanLocator {
    private static final Logger LOG = LogUtils.getL7dLogger(BlueprintBeanLocator.class);
    ConfiguredBeanLocator orig;
    BlueprintContainer container;
    BundleContext context;

    public BlueprintBeanLocator(ConfiguredBeanLocator orig, BlueprintContainer cont, BundleContext context) {
        this.orig = orig;
        this.container = cont;
        this.context = context;
        if (orig instanceof ExtensionManagerImpl) {
            ArrayList<String> names = new ArrayList<String>(this.container.getComponentIds());
            ((ExtensionManagerImpl)orig).removeBeansOfNames(names);
        }
    }

    static Class<?> getClassForMetaData(BlueprintContainer container, ComponentMetadata cmd) {
        Class cls = null;
        if (cmd instanceof BeanMetadata) {
            BeanMetadata bm = (BeanMetadata)cmd;
            if (bm instanceof ExtendedBeanMetadata) {
                cls = ((ExtendedBeanMetadata)bm).getRuntimeClass();
            }
            if (cls == null && bm.getClassName() != null) {
                try {
                    Method m = ReflectionUtil.findMethod(container.getClass(), (String)"loadClass", (Class[])new Class[]{String.class});
                    cls = (Class)((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)container, bm.getClassName());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return cls;
    }

    private Class<?> getClassForMetaData(ComponentMetadata cmd) {
        return BlueprintBeanLocator.getClassForMetaData(this.container, cmd);
    }

    private ComponentMetadata getComponentMetadata(String id) {
        try {
            return this.container.getComponentMetadata(id);
        }
        catch (NoSuchComponentException nsce) {
            return null;
        }
    }

    public <T> T getBeanOfType(String name, Class<T> type) {
        ComponentMetadata cmd = this.getComponentMetadata(name);
        Class<?> cls = this.getClassForMetaData(cmd);
        if (cls != null && type.isAssignableFrom(cls)) {
            return type.cast(this.container.getComponentInstance(name));
        }
        return (T)this.orig.getBeanOfType(name, type);
    }

    public List<String> getBeanNamesOfType(Class<?> type) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Object s : this.container.getComponentIds()) {
            ComponentMetadata cmd = this.container.getComponentMetadata(s.toString());
            Class<?> cls = this.getClassForMetaData(cmd);
            if (cls == null || !type.isAssignableFrom(cls)) continue;
            names.add(s.toString());
        }
        names.addAll(this.orig.getBeanNamesOfType(type));
        return new ArrayList<String>(names);
    }

    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object s : this.container.getComponentIds()) {
            ComponentMetadata cmd = this.container.getComponentMetadata(s.toString());
            Class<?> cls = this.getClassForMetaData(cmd);
            if (cls == null || !type.isAssignableFrom(cls)) continue;
            list.add(type.cast(this.container.getComponentInstance(s.toString())));
        }
        list.addAll(this.orig.getBeansOfType(type));
        if (list.isEmpty()) {
            try {
                ServiceReference[] refs = this.context.getServiceReferences(type.getName(), null);
                if (refs != null) {
                    for (ServiceReference r : refs) {
                        list.add(type.cast(this.context.getService(r)));
                    }
                }
            }
            catch (Exception ex) {
                LOG.info("Try to find the Bean with type:" + type + " from OSGi services and get error: " + ex);
            }
        }
        return list;
    }

    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        ComponentMetadata cmd;
        ArrayList<String> names = new ArrayList<String>();
        boolean loaded = false;
        for (Object e : this.container.getComponentIds()) {
            cmd = this.container.getComponentMetadata(e.toString());
            Class<?> cls = this.getClassForMetaData(cmd);
            if (cls == null || !type.isAssignableFrom(cls)) continue;
            names.add(e.toString());
        }
        Collections.reverse(names);
        for (String string : names) {
            Class<?> beanType;
            Class<T> t;
            if (!listener.loadBean(string, t = (beanType = this.getClassForMetaData(cmd = this.container.getComponentMetadata(string))).asSubclass(type))) continue;
            Object o = this.container.getComponentInstance(string);
            if (listener.beanLoaded(string, type.cast(o))) {
                return true;
            }
            loaded = true;
        }
        return loaded || this.orig.loadBeansOfType(type, listener);
    }

    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
        ComponentMetadata cmd = this.getComponentMetadata(beanName);
        if (cmd instanceof BeanMetadata) {
            BeanMetadata br = (BeanMetadata)cmd;
            for (Object s : br.getProperties()) {
                if (!propertyName.equals(((BeanProperty)s).getName())) continue;
                return true;
            }
            return false;
        }
        return this.orig.hasConfiguredPropertyValue(beanName, propertyName, value);
    }

    public boolean hasBeanOfName(String name) {
        ComponentMetadata cmd = this.getComponentMetadata(name);
        if (cmd instanceof BeanMetadata) {
            return true;
        }
        return this.orig.hasBeanOfName(name);
    }
}

